/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractBus;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.BusTerminal;
import com.powsybl.iidm.network.impl.ConfiguredBus;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.util.Ref;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ConfiguredBusImpl
extends AbstractBus
implements ConfiguredBus {
    private final Ref<NetworkImpl> network;
    private final ArrayList<List<BusTerminal>> terminals;
    private final TDoubleArrayList v;
    private final TDoubleArrayList angle;
    private final TDoubleArrayList fictitiousP0;
    private final TDoubleArrayList fictitiousQ0;
    private final TIntArrayList connectedComponentNumber;
    private final TIntArrayList synchronousComponentNumber;

    ConfiguredBusImpl(String id, String name, boolean fictitious, VoltageLevelExt voltageLevel) {
        super(id, name, fictitious, voltageLevel);
        this.network = voltageLevel.getNetworkRef();
        int variantArraySize = this.network.get().getVariantManager().getVariantArraySize();
        this.terminals = new ArrayList(variantArraySize);
        this.v = new TDoubleArrayList(variantArraySize);
        this.angle = new TDoubleArrayList(variantArraySize);
        this.fictitiousP0 = new TDoubleArrayList(variantArraySize);
        this.fictitiousQ0 = new TDoubleArrayList(variantArraySize);
        this.connectedComponentNumber = new TIntArrayList(variantArraySize);
        this.synchronousComponentNumber = new TIntArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.terminals.add(new ArrayList());
            this.v.add(Double.NaN);
            this.angle.add(Double.NaN);
            this.fictitiousP0.add(0.0);
            this.fictitiousQ0.add(0.0);
            this.connectedComponentNumber.add(-1);
            this.synchronousComponentNumber.add(-1);
        }
    }

    public int getConnectedTerminalCount() {
        return (int)this.getTerminals().stream().filter(BusTerminal::isConnected).count();
    }

    public List<TerminalExt> getConnectedTerminals() {
        return this.getConnectedTerminalStream().collect(Collectors.toList());
    }

    @Override
    public Stream<TerminalExt> getConnectedTerminalStream() {
        return this.getTerminals().stream().filter(Terminal::isConnected).map(Function.identity());
    }

    @Override
    public int getTerminalCount() {
        return this.terminals.get(this.network.get().getVariantIndex()).size();
    }

    @Override
    public List<BusTerminal> getTerminals() {
        return this.terminals.get(this.network.get().getVariantIndex());
    }

    @Override
    public void addTerminal(BusTerminal t) {
        this.terminals.get(this.network.get().getVariantIndex()).add(t);
    }

    @Override
    public void removeTerminal(BusTerminal t) {
        if (!this.terminals.get(this.network.get().getVariantIndex()).remove(t)) {
            throw new IllegalStateException("Terminal " + t + " not found");
        }
    }

    protected <S, T extends S> void notifyUpdate(String attribute, String variantId, S oldValue, T newValue) {
        this.network.get().getListeners().notifyUpdate(this, attribute, variantId, oldValue, newValue);
    }

    public double getV() {
        return this.v.get(this.network.get().getVariantIndex());
    }

    public BusExt setV(double v) {
        if (v < 0.0) {
            throw new ValidationException((Validable)this, "voltage cannot be < 0");
        }
        int variantIndex = this.network.get().getVariantIndex();
        double oldValue = this.v.set(variantIndex, v);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("v", variantId, oldValue, v);
        return this;
    }

    public double getAngle() {
        return this.angle.get(this.network.get().getVariantIndex());
    }

    public BusExt setAngle(double angle) {
        int variantIndex = this.network.get().getVariantIndex();
        double oldValue = this.angle.set(variantIndex, angle);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("angle", variantId, oldValue, angle);
        return this;
    }

    public double getFictitiousP0() {
        return this.fictitiousP0.get(this.network.get().getVariantIndex());
    }

    public Bus setFictitiousP0(double p0) {
        if (Double.isNaN(p0)) {
            throw new ValidationException((Validable)this, "undefined value cannot be set as fictitious p0");
        }
        int variantIndex = this.network.get().getVariantIndex();
        double oldValue = this.fictitiousP0.set(variantIndex, p0);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("fictitiousP0", variantId, oldValue, p0);
        return this;
    }

    public double getFictitiousQ0() {
        return this.fictitiousQ0.get(this.network.get().getVariantIndex());
    }

    public Bus setFictitiousQ0(double q0) {
        if (Double.isNaN(q0)) {
            throw new ValidationException((Validable)this, "undefined value cannot be set as fictitious q0");
        }
        int variantIndex = this.network.get().getVariantIndex();
        double oldValue = this.fictitiousQ0.set(variantIndex, q0);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("fictitiousQ0", variantId, oldValue, q0);
        return this;
    }

    @Override
    public void setConnectedComponentNumber(int connectedComponentNumber) {
        int variantIndex = this.network.get().getVariantIndex();
        int oldValue = this.connectedComponentNumber.set(variantIndex, connectedComponentNumber);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("connectedComponentNumber", variantId, oldValue, connectedComponentNumber);
    }

    public Component getConnectedComponent() {
        NetworkImpl.ConnectedComponentsManager ccm = this.voltageLevel.getNetwork().getConnectedComponentsManager();
        ccm.update();
        return ccm.getComponent(this.connectedComponentNumber.get(this.network.get().getVariantIndex()));
    }

    @Override
    public void setSynchronousComponentNumber(int componentNumber) {
        int variantIndex = this.network.get().getVariantIndex();
        int oldValue = this.synchronousComponentNumber.set(variantIndex, componentNumber);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("synchronousComponentNumber", variantId, oldValue, componentNumber);
    }

    public Component getSynchronousComponent() {
        NetworkImpl.SynchronousComponentsManager scm = this.voltageLevel.getNetwork().getSynchronousComponentsManager();
        scm.update();
        return scm.getComponent(this.synchronousComponentNumber.get(this.network.get().getVariantIndex()));
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.terminals.ensureCapacity(this.terminals.size() + number);
        this.v.ensureCapacity(this.v.size() + number);
        this.angle.ensureCapacity(this.angle.size() + number);
        this.fictitiousP0.ensureCapacity(this.fictitiousP0.size() + number);
        this.fictitiousQ0.ensureCapacity(this.fictitiousQ0.size() + number);
        this.connectedComponentNumber.ensureCapacity(this.connectedComponentNumber.size() + number);
        this.synchronousComponentNumber.ensureCapacity(this.synchronousComponentNumber.size() + number);
        for (int i = 0; i < number; ++i) {
            this.terminals.add(new ArrayList(this.terminals.get(sourceIndex)));
            this.v.add(this.v.get(sourceIndex));
            this.angle.add(this.angle.get(sourceIndex));
            this.fictitiousP0.add(this.fictitiousP0.get(sourceIndex));
            this.fictitiousQ0.add(this.fictitiousQ0.get(sourceIndex));
            this.connectedComponentNumber.add(this.connectedComponentNumber.get(sourceIndex));
            this.synchronousComponentNumber.add(this.synchronousComponentNumber.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        for (int i = 0; i < number; ++i) {
            this.terminals.remove(this.terminals.size() - 1);
        }
        this.v.remove(this.v.size() - number, number);
        this.angle.remove(this.angle.size() - number, number);
        this.fictitiousP0.remove(this.fictitiousP0.size() - number, number);
        this.fictitiousQ0.remove(this.fictitiousQ0.size() - number, number);
        this.connectedComponentNumber.remove(this.connectedComponentNumber.size() - number, number);
        this.synchronousComponentNumber.remove(this.synchronousComponentNumber.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.terminals.set(index, null);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.terminals.set(index, new ArrayList(this.terminals.get(sourceIndex)));
            this.v.set(index, this.v.get(sourceIndex));
            this.angle.set(index, this.angle.get(sourceIndex));
            this.fictitiousP0.set(index, this.fictitiousP0.get(sourceIndex));
            this.fictitiousQ0.set(index, this.fictitiousQ0.get(sourceIndex));
            this.connectedComponentNumber.set(index, this.connectedComponentNumber.get(sourceIndex));
            this.synchronousComponentNumber.set(index, this.synchronousComponentNumber.get(sourceIndex));
        }
    }
}

