/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractInjectionAdder;
import com.powsybl.iidm.network.impl.GeneratorImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

class GeneratorAdderImpl
extends AbstractInjectionAdder<GeneratorAdderImpl>
implements GeneratorAdder {
    private EnergySource energySource = EnergySource.OTHER;
    private double minP = Double.NaN;
    private double maxP = Double.NaN;
    private TerminalExt regulatingTerminal;
    private Boolean voltageRegulatorOn;
    private double targetP = Double.NaN;
    private double targetQ = Double.NaN;
    private double targetV = Double.NaN;
    private double ratedS = Double.NaN;

    GeneratorAdderImpl(VoltageLevelExt voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    @Override
    protected String getTypeDescription() {
        return "Generator";
    }

    public GeneratorAdderImpl setEnergySource(EnergySource energySource) {
        this.energySource = energySource;
        return this;
    }

    public GeneratorAdderImpl setMaxP(double maxP) {
        this.maxP = maxP;
        return this;
    }

    public GeneratorAdderImpl setMinP(double minP) {
        this.minP = minP;
        return this;
    }

    public GeneratorAdder setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        this.voltageRegulatorOn = voltageRegulatorOn;
        return this;
    }

    public GeneratorAdder setRegulatingTerminal(Terminal regulatingTerminal) {
        this.regulatingTerminal = (TerminalExt)regulatingTerminal;
        return this;
    }

    public GeneratorAdderImpl setTargetP(double targetP) {
        this.targetP = targetP;
        return this;
    }

    public GeneratorAdderImpl setTargetQ(double targetQ) {
        this.targetQ = targetQ;
        return this;
    }

    public GeneratorAdderImpl setTargetV(double targetV) {
        this.targetV = targetV;
        return this;
    }

    public GeneratorAdder setRatedS(double ratedS) {
        this.ratedS = ratedS;
        return this;
    }

    public GeneratorImpl add() {
        NetworkImpl network = this.getNetwork();
        if (network.getMinValidationLevel() == ValidationLevel.EQUIPMENT && this.voltageRegulatorOn == null) {
            this.voltageRegulatorOn = false;
        }
        String id = this.checkAndGetUniqueId();
        TerminalExt terminal = this.checkAndGetTerminal();
        ValidationUtil.checkEnergySource((Validable)this, (EnergySource)this.energySource);
        ValidationUtil.checkMinP((Validable)this, (double)this.minP);
        ValidationUtil.checkMaxP((Validable)this, (double)this.maxP);
        ValidationUtil.checkActivePowerLimits((Validable)this, (double)this.minP, (double)this.maxP);
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)this.regulatingTerminal, (Network)network);
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkActivePowerSetpoint((Validable)this, (double)this.targetP, (ValidationLevel)network.getMinValidationLevel()));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.voltageRegulatorOn, (double)this.targetV, (double)this.targetQ, (ValidationLevel)network.getMinValidationLevel()));
        ValidationUtil.checkActivePowerLimits((Validable)this, (double)this.minP, (double)this.maxP);
        ValidationUtil.checkRatedS((Validable)this, (double)this.ratedS);
        GeneratorImpl generator = new GeneratorImpl(this.getNetworkRef(), id, this.getName(), this.isFictitious(), this.energySource, this.minP, this.maxP, this.voltageRegulatorOn, this.regulatingTerminal != null ? this.regulatingTerminal : terminal, this.targetP, this.targetQ, this.targetV, this.ratedS);
        generator.addTerminal(terminal);
        this.voltageLevel.attach(terminal, false);
        network.getIndex().checkAndAdd(generator);
        network.getListeners().notifyCreation(generator);
        return generator;
    }
}

