/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractAutomationSystem;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class OverloadManagementSystemImpl
extends AbstractAutomationSystem<OverloadManagementSystem>
implements OverloadManagementSystem {
    private final SubstationImpl substation;
    private final String monitoredElementId;
    private final ThreeSides monitoredSide;
    private final List<OverloadManagementSystem.Tripping> trippings;

    OverloadManagementSystemImpl(String id, String name, SubstationImpl substation, String monitoredElementId, ThreeSides monitoredSide, boolean enabled) {
        super(Objects.requireNonNull(substation).getNetworkRef(), id, name, enabled);
        this.substation = Objects.requireNonNull(substation);
        this.monitoredElementId = this.checkMonitoredElementId(monitoredElementId);
        this.monitoredSide = Objects.requireNonNull(monitoredSide);
        this.trippings = new ArrayList<OverloadManagementSystem.Tripping>();
    }

    private String checkMonitoredElementId(String monitoredElementId) {
        if (monitoredElementId == null) {
            throw new ValidationException((Validable)this, "monitoredElementId is not set");
        }
        Identifiable<?> element = this.getNetwork().getIdentifiable(monitoredElementId);
        if (element == null) {
            throw new ValidationException((Validable)this, " '" + monitoredElementId + "' not found");
        }
        return monitoredElementId;
    }

    public Substation getSubstation() {
        return this.substation;
    }

    @Override
    public NetworkImpl getNetwork() {
        return this.substation.getNetwork();
    }

    public Network getParentNetwork() {
        return this.substation.getParentNetwork();
    }

    @Override
    protected String getTypeDescription() {
        return "Overload management system";
    }

    public String getMonitoredElementId() {
        return this.monitoredElementId;
    }

    public ThreeSides getMonitoredSide() {
        return this.monitoredSide;
    }

    public void addTripping(OverloadManagementSystem.Tripping tripping) {
        this.trippings.add(tripping);
    }

    public List<OverloadManagementSystem.Tripping> getTrippings() {
        return Collections.unmodifiableList(this.trippings);
    }

    static class ThreeWindingsTransformerTrippingImpl
    extends AbstractTrippingImpl
    implements OverloadManagementSystem.ThreeWindingsTransformerTripping {
        private String threeWindingsTransformerId;
        private ThreeSides side;

        protected ThreeWindingsTransformerTrippingImpl(String overloadManagementSystemId, String key, String name, double currentLimit, boolean openAction, String threeWindingsTransformerId, ThreeSides side) {
            super(overloadManagementSystemId, key, name, currentLimit, openAction);
            this.setThreeWindingsTransformerToOperateId(threeWindingsTransformerId);
            this.setSideToOperate(side);
        }

        public String getThreeWindingsTransformerToOperateId() {
            return this.threeWindingsTransformerId;
        }

        public OverloadManagementSystem.ThreeWindingsTransformerTripping setThreeWindingsTransformerToOperateId(String threeWindingsTransformerId) {
            this.threeWindingsTransformerId = Objects.requireNonNull(threeWindingsTransformerId);
            return this;
        }

        public ThreeSides getSideToOperate() {
            return this.side;
        }

        public OverloadManagementSystem.ThreeWindingsTransformerTripping setSideToOperate(ThreeSides side) {
            this.side = Objects.requireNonNull(side);
            return this;
        }
    }

    static class BranchTrippingImpl
    extends AbstractTrippingImpl
    implements OverloadManagementSystem.BranchTripping {
        private String branchToOperateId;
        private TwoSides side;

        protected BranchTrippingImpl(String overloadManagementSystemId, String key, String name, double currentLimit, boolean openAction, String branchToOperateId, TwoSides side) {
            super(overloadManagementSystemId, key, name, currentLimit, openAction);
            this.setBranchToOperateId(branchToOperateId);
            this.setSideToOperate(side);
        }

        public String getBranchToOperateId() {
            return this.branchToOperateId;
        }

        public OverloadManagementSystem.BranchTripping setBranchToOperateId(String branchId) {
            this.branchToOperateId = Objects.requireNonNull(branchId);
            return this;
        }

        public TwoSides getSideToOperate() {
            return this.side;
        }

        public OverloadManagementSystem.BranchTripping setSideToOperate(TwoSides side) {
            this.side = Objects.requireNonNull(side);
            return this;
        }
    }

    static class SwitchTrippingImpl
    extends AbstractTrippingImpl
    implements OverloadManagementSystem.SwitchTripping {
        private String switchToOperateId;

        public SwitchTrippingImpl(String overloadManagementSystemId, String key, String name, double currentLimit, boolean openAction, String switchToOperateId) {
            super(overloadManagementSystemId, key, name, currentLimit, openAction);
            this.setSwitchToOperateId(switchToOperateId);
        }

        public String getSwitchToOperateId() {
            return this.switchToOperateId;
        }

        public OverloadManagementSystem.SwitchTripping setSwitchToOperateId(String switchToOperateId) {
            this.switchToOperateId = Objects.requireNonNull(switchToOperateId);
            return this;
        }
    }

    static abstract class AbstractTrippingImpl
    implements OverloadManagementSystem.Tripping,
    Validable {
        private final String overloadManagementSystemId;
        private final String key;
        private String name;
        private double currentLimit;
        private boolean openAction;

        protected AbstractTrippingImpl(String overloadManagementSystemId, String key, String name, double currentLimit, boolean openAction) {
            this.overloadManagementSystemId = overloadManagementSystemId;
            this.key = Objects.requireNonNull(key);
            this.setName(name);
            this.setCurrentLimit(currentLimit);
            this.setOpenAction(openAction);
        }

        public String getKey() {
            return this.key;
        }

        public String getNameOrKey() {
            return this.name != null ? this.name : this.key;
        }

        public OverloadManagementSystem.Tripping setName(String name) {
            this.name = name;
            return this;
        }

        public double getCurrentLimit() {
            return this.currentLimit;
        }

        public OverloadManagementSystem.Tripping setCurrentLimit(double currentLimit) {
            if (Double.isNaN(currentLimit)) {
                throw new ValidationException((Validable)this, "Current limit is mandatory.");
            }
            if (currentLimit < 0.0) {
                throw new ValidationException((Validable)this, "Current limit must be positive.");
            }
            this.currentLimit = currentLimit;
            return this;
        }

        public boolean isOpenAction() {
            return this.openAction;
        }

        public OverloadManagementSystem.Tripping setOpenAction(boolean open) {
            this.openAction = open;
            return this;
        }

        protected String getTrippingAttribute() {
            return String.format("tripping '%s'", this.key);
        }

        public String getMessageHeader() {
            return String.format("Overload management system '%s' - %s:", this.overloadManagementSystemId, this.getTrippingAttribute());
        }
    }
}

