/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ZipLoadModelAdder;
import com.powsybl.iidm.network.impl.LoadAdderImpl;
import com.powsybl.iidm.network.impl.ZipLoadModelImpl;
import java.util.Objects;

public class ZipLoadModelAdderImpl
implements ZipLoadModelAdder {
    private final LoadAdderImpl parentAdder;
    private double c0p = 1.0;
    private double c1p = 0.0;
    private double c2p = 0.0;
    private double c0q = 1.0;
    private double c1q = 0.0;
    private double c2q = 0.0;

    public ZipLoadModelAdderImpl(LoadAdderImpl parentAdder) {
        this.parentAdder = Objects.requireNonNull(parentAdder);
    }

    public ZipLoadModelAdderImpl setC0p(double c0p) {
        this.c0p = ZipLoadModelImpl.checkCoefficient(this.parentAdder, c0p);
        return this;
    }

    public ZipLoadModelAdderImpl setC1p(double c1p) {
        this.c1p = ZipLoadModelImpl.checkCoefficient(this.parentAdder, c1p);
        return this;
    }

    public ZipLoadModelAdderImpl setC2p(double c2p) {
        this.c2p = ZipLoadModelImpl.checkCoefficient(this.parentAdder, c2p);
        return this;
    }

    public ZipLoadModelAdderImpl setC0q(double c0q) {
        this.c0q = ZipLoadModelImpl.checkCoefficient(this.parentAdder, c0q);
        return this;
    }

    public ZipLoadModelAdderImpl setC1q(double c1q) {
        this.c1q = ZipLoadModelImpl.checkCoefficient(this.parentAdder, c1q);
        return this;
    }

    public ZipLoadModelAdderImpl setC2q(double c2q) {
        this.c2q = ZipLoadModelImpl.checkCoefficient(this.parentAdder, c2q);
        return this;
    }

    public LoadAdderImpl add() {
        if (Math.abs(this.c0p + this.c1p + this.c2p - 1.0) > 1.0E-8) {
            throw new ValidationException((Validable)this.parentAdder, "Sum of c0p, c1p and c2p should be 1");
        }
        if (Math.abs(this.c0q + this.c1q + this.c2q - 1.0) > 1.0E-8) {
            throw new ValidationException((Validable)this.parentAdder, "Sum of c0q, c1q and c2q should be 1");
        }
        this.parentAdder.setModel(new ZipLoadModelImpl(this.c0p, this.c1p, this.c2p, this.c0q, this.c1q, this.c2q));
        return this.parentAdder;
    }
}

