/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.ReferencePriorities;
import com.powsybl.iidm.network.extensions.ReferencePriority;
import com.powsybl.iidm.network.extensions.ReferencePriorityAdder;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import com.powsybl.iidm.network.impl.extensions.ReferencePriorityAdderImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ReferencePrioritiesImpl<C extends Connectable<C>>
extends AbstractMultiVariantIdentifiableExtension<C>
implements ReferencePriorities<C> {
    private final ArrayList<Map<Terminal, ReferencePriority>> referencePrioritiesPerVariant = new ArrayList(Collections.nCopies(this.getVariantManagerHolder().getVariantManager().getVariantArraySize(), new LinkedHashMap()));

    public ReferencePrioritiesImpl(C extendable) {
        super(extendable);
    }

    ReferencePrioritiesImpl<C> add(ReferencePriority referencePriority) {
        if (!((Connectable)this.getExtendable()).getTerminals().contains(referencePriority.getTerminal())) {
            throw new PowsyblException(String.format("The provided terminal does not belong to the connectable %s", ((Connectable)this.getExtendable()).getId()));
        }
        this.referencePrioritiesPerVariant.get(this.getVariantIndex()).put(referencePriority.getTerminal(), referencePriority);
        return this;
    }

    public ReferencePriorityAdder newReferencePriority() {
        return new ReferencePriorityAdderImpl(this);
    }

    public List<ReferencePriority> getReferencePriorities() {
        return this.referencePrioritiesPerVariant.get(this.getVariantIndex()).values().stream().toList();
    }

    public void deleteReferencePriorities() {
        this.referencePrioritiesPerVariant.get(this.getVariantIndex()).clear();
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.referencePrioritiesPerVariant.ensureCapacity(this.referencePrioritiesPerVariant.size() + number);
        Map<Terminal, ReferencePriority> sourcePriorities = this.referencePrioritiesPerVariant.get(sourceIndex);
        for (int i = 0; i < number; ++i) {
            this.referencePrioritiesPerVariant.add(new LinkedHashMap<Terminal, ReferencePriority>(sourcePriorities));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int i = 0; i < number; ++i) {
            this.referencePrioritiesPerVariant.remove(this.referencePrioritiesPerVariant.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.referencePrioritiesPerVariant.set(index, null);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        Map<Terminal, ReferencePriority> sourcePriorities = this.referencePrioritiesPerVariant.get(sourceIndex);
        for (int index : indexes) {
            this.referencePrioritiesPerVariant.set(index, new LinkedHashMap<Terminal, ReferencePriority>(sourcePriorities));
        }
    }
}

