/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.AutomationSystem;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.util.Ref;
import java.util.Objects;

abstract class AbstractAutomationSystem<I extends AutomationSystem<I>>
extends AbstractIdentifiable<I>
implements AutomationSystem<I> {
    private final TBooleanArrayList enabled;

    AbstractAutomationSystem(Ref<NetworkImpl> networkRef, String id, String name, boolean enabled) {
        super(id, name);
        Objects.requireNonNull(networkRef);
        int variantArraySize = networkRef.get().getVariantManager().getVariantArraySize();
        this.enabled = new TBooleanArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.enabled.add(enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled.get(this.getNetwork().getVariantIndex());
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set(this.getNetwork().getVariantIndex(), enabled);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.enabled.ensureCapacity(this.enabled.size() + number);
        this.enabled.fill(initVariantArraySize, initVariantArraySize + number, this.enabled.get(sourceIndex));
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.enabled.remove(this.enabled.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.enabled.set(index, this.enabled.get(sourceIndex));
        }
    }
}

