/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.BranchUtil;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.OperationalLimitsGroupsImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.util.Ref;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import java.util.Collection;
import java.util.Optional;

abstract class AbstractConnectableBranch<I extends Branch<I> & Connectable<I>>
extends AbstractConnectable<I>
implements Branch<I> {
    private final FlowsLimitsHolder operationalLimitsHolder1 = new OperationalLimitsGroupsImpl(this, "limits1");
    private final FlowsLimitsHolder operationalLimitsHolder2 = new OperationalLimitsGroupsImpl(this, "limits2");

    AbstractConnectableBranch(Ref<NetworkImpl> network, String id, String name, boolean fictitious) {
        super(network, id, name, fictitious);
    }

    public TerminalExt getTerminal1() {
        return (TerminalExt)this.terminals.get(0);
    }

    public TerminalExt getTerminal2() {
        return (TerminalExt)this.terminals.get(1);
    }

    public Terminal getTerminal(TwoSides side) {
        return BranchUtil.getFromSide(side, this::getTerminal1, this::getTerminal2);
    }

    public Terminal getTerminal(String voltageLevelId) {
        return BranchUtil.getTerminal(voltageLevelId, this.getTerminal1(), this.getTerminal2());
    }

    public TwoSides getSide(Terminal terminal) {
        return BranchUtil.getSide(terminal, this.getTerminal1(), this.getTerminal2());
    }

    private FlowsLimitsHolder getOperationalLimitsHolder1() {
        return this.operationalLimitsHolder1;
    }

    public Optional<String> getSelectedOperationalLimitsGroupId1() {
        return this.getOperationalLimitsHolder1().getSelectedOperationalLimitsGroupId();
    }

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups1() {
        return this.getOperationalLimitsHolder1().getOperationalLimitsGroups();
    }

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup1(String id) {
        return this.getOperationalLimitsHolder1().getOperationalLimitsGroup(id);
    }

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup1() {
        return this.getOperationalLimitsHolder1().getSelectedOperationalLimitsGroup();
    }

    public OperationalLimitsGroup newOperationalLimitsGroup1(String id) {
        return this.getOperationalLimitsHolder1().newOperationalLimitsGroup(id);
    }

    public void setSelectedOperationalLimitsGroup1(String id) {
        this.getOperationalLimitsHolder1().setSelectedOperationalLimitsGroup(id);
    }

    public void removeOperationalLimitsGroup1(String id) {
        this.getOperationalLimitsHolder1().removeOperationalLimitsGroup(id);
    }

    public void cancelSelectedOperationalLimitsGroup1() {
        this.getOperationalLimitsHolder1().cancelSelectedOperationalLimitsGroup();
    }

    public CurrentLimitsAdder newCurrentLimits1() {
        return this.getOperationalLimitsHolder1().newCurrentLimits();
    }

    public ActivePowerLimitsAdder newActivePowerLimits1() {
        return this.getOperationalLimitsHolder1().newActivePowerLimits();
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits1() {
        return this.getOperationalLimitsHolder1().newApparentPowerLimits();
    }

    private FlowsLimitsHolder getOperationalLimitsHolder2() {
        return this.operationalLimitsHolder2;
    }

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups2() {
        return this.getOperationalLimitsHolder2().getOperationalLimitsGroups();
    }

    public Optional<String> getSelectedOperationalLimitsGroupId2() {
        return this.getOperationalLimitsHolder2().getSelectedOperationalLimitsGroupId();
    }

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup2(String id) {
        return this.getOperationalLimitsHolder2().getOperationalLimitsGroup(id);
    }

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup2() {
        return this.getOperationalLimitsHolder2().getSelectedOperationalLimitsGroup();
    }

    public OperationalLimitsGroup newOperationalLimitsGroup2(String id) {
        return this.getOperationalLimitsHolder2().newOperationalLimitsGroup(id);
    }

    public void setSelectedOperationalLimitsGroup2(String id) {
        this.getOperationalLimitsHolder2().setSelectedOperationalLimitsGroup(id);
    }

    public void removeOperationalLimitsGroup2(String id) {
        this.getOperationalLimitsHolder2().removeOperationalLimitsGroup(id);
    }

    public void cancelSelectedOperationalLimitsGroup2() {
        this.getOperationalLimitsHolder2().cancelSelectedOperationalLimitsGroup();
    }

    public CurrentLimitsAdder newCurrentLimits2() {
        return this.getOperationalLimitsHolder2().newCurrentLimits();
    }

    public ActivePowerLimitsAdder newActivePowerLimits2() {
        return this.getOperationalLimitsHolder2().newActivePowerLimits();
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits2() {
        return this.getOperationalLimitsHolder2().newApparentPowerLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, () -> ((AbstractConnectableBranch)this).getCurrentLimits1(), () -> ((AbstractConnectableBranch)this).getCurrentLimits2());
    }

    public Optional<ActivePowerLimits> getActivePowerLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, () -> ((AbstractConnectableBranch)this).getActivePowerLimits1(), () -> ((AbstractConnectableBranch)this).getActivePowerLimits2());
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, () -> ((AbstractConnectableBranch)this).getApparentPowerLimits1(), () -> ((AbstractConnectableBranch)this).getApparentPowerLimits2());
    }

    public boolean isOverloaded() {
        return this.isOverloaded(1.0f);
    }

    public boolean isOverloaded(float limitReduction) {
        return this.checkPermanentLimit1(limitReduction, LimitType.CURRENT) || this.checkPermanentLimit2(limitReduction, LimitType.CURRENT);
    }

    public int getOverloadDuration() {
        return BranchUtil.getOverloadDuration(this.checkTemporaryLimits1(LimitType.CURRENT), this.checkTemporaryLimits2(LimitType.CURRENT));
    }

    public boolean checkPermanentLimit(TwoSides side, float limitReduction, LimitType type) {
        return BranchUtil.getFromSide(side, () -> this.checkPermanentLimit1(limitReduction, type), () -> this.checkPermanentLimit2(limitReduction, type));
    }

    public boolean checkPermanentLimit(TwoSides side, LimitType type) {
        return this.checkPermanentLimit(side, 1.0f, type);
    }

    public boolean checkPermanentLimit1(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit((Branch)this, (TwoSides)TwoSides.ONE, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal1(), type), (LimitType)type);
    }

    public boolean checkPermanentLimit1(LimitType type) {
        return this.checkPermanentLimit1(1.0f, type);
    }

    public boolean checkPermanentLimit2(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit((Branch)this, (TwoSides)TwoSides.TWO, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal2(), type), (LimitType)type);
    }

    public boolean checkPermanentLimit2(LimitType type) {
        return this.checkPermanentLimit2(1.0f, type);
    }

    public Overload checkTemporaryLimits(TwoSides side, float limitReduction, LimitType type) {
        return BranchUtil.getFromSide(side, () -> this.checkTemporaryLimits1(limitReduction, type), () -> this.checkTemporaryLimits2(limitReduction, type));
    }

    public Overload checkTemporaryLimits(TwoSides side, LimitType type) {
        return this.checkTemporaryLimits(side, 1.0f, type);
    }

    public Overload checkTemporaryLimits1(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits((Branch)this, (TwoSides)TwoSides.ONE, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal1(), type), (LimitType)type);
    }

    public Overload checkTemporaryLimits1(LimitType type) {
        return this.checkTemporaryLimits1(1.0f, type);
    }

    public Overload checkTemporaryLimits2(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits((Branch)this, (TwoSides)TwoSides.TWO, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal2(), type), (LimitType)type);
    }

    public Overload checkTemporaryLimits2(LimitType type) {
        return this.checkTemporaryLimits2(1.0f, type);
    }

    public double getValueForLimit(Terminal t, LimitType type) {
        return BranchUtil.getValueForLimit(t, type);
    }
}

