/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.util.Ref;
import com.powsybl.iidm.network.util.Identifiables;
import java.util.Arrays;
import java.util.function.Predicate;

abstract class AbstractIdentifiableAdder<T extends AbstractIdentifiableAdder<T>>
implements Validable {
    private String id;
    private boolean ensureIdUnicity = false;
    private String name;
    private boolean fictitious = false;

    AbstractIdentifiableAdder() {
    }

    protected abstract NetworkImpl getNetwork();

    protected abstract String getTypeDescription();

    public T setId(String id) {
        this.id = id;
        return (T)this;
    }

    public T setEnsureIdUnicity(boolean ensureIdUnicity) {
        this.ensureIdUnicity = ensureIdUnicity;
        return (T)this;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public T setFictitious(boolean fictitious) {
        this.fictitious = fictitious;
        return (T)this;
    }

    protected String checkAndGetUniqueId() {
        return this.checkAndGetUniqueId(this.getNetwork().getIndex()::contains);
    }

    protected String checkAndGetUniqueId(Predicate<String> containsId) {
        String uniqueId;
        if (this.id == null) {
            throw new PowsyblException(this.getTypeDescription() + " id is not set");
        }
        if (this.ensureIdUnicity) {
            uniqueId = Identifiables.getUniqueId((String)this.id, containsId);
        } else {
            if (containsId.test(this.id)) {
                Identifiable obj = this.getNetwork().getIndex().get(this.id);
                throw new PowsyblException("The network " + this.getNetwork().getId() + " already contains an object '" + obj.getClass().getSimpleName() + "' with the id '" + this.id + "'");
            }
            uniqueId = this.id;
        }
        return uniqueId;
    }

    protected String getName() {
        return this.name;
    }

    protected boolean isFictitious() {
        return this.fictitious;
    }

    public String getMessageHeader() {
        return this.getTypeDescription() + " '" + this.id + "': ";
    }

    protected static Ref<NetworkImpl> computeNetworkRef(NetworkImpl network, VoltageLevelExt ... voltageLevels) {
        if (voltageLevels.length == 0) {
            return network.getRef();
        }
        String subnetworkId = voltageLevels[0].getSubnetworkId();
        if (subnetworkId == null) {
            return network.getRef();
        }
        boolean existDifferentSubnetworkId = Arrays.stream(voltageLevels, 1, voltageLevels.length).map(VoltageLevelExt::getSubnetworkId).anyMatch(Predicate.not(subnetworkId::equals));
        if (existDifferentSubnetworkId) {
            return network.getRef();
        }
        return voltageLevels[0].getNetworkRef();
    }
}

