/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.MinMaxReactiveLimitsAdder;
import com.powsybl.iidm.network.ReactiveCapabilityCurveAdder;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsAdderImpl;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ReactiveCapabilityCurveAdderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsHolderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsOwner;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.util.Ref;
import gnu.trove.list.array.TDoubleArrayList;

public class BatteryImpl
extends AbstractConnectable<Battery>
implements Battery,
ReactiveLimitsOwner {
    private final ReactiveLimitsHolderImpl reactiveLimits;
    private final TDoubleArrayList targetP;
    private final TDoubleArrayList targetQ;
    private double minP;
    private double maxP;

    BatteryImpl(Ref<NetworkImpl> ref, String id, String name, boolean fictitious, double targetP, double targetQ, double minP, double maxP) {
        super(ref, id, name, fictitious);
        this.minP = minP;
        this.maxP = maxP;
        this.reactiveLimits = new ReactiveLimitsHolderImpl(this, (ReactiveLimits)new MinMaxReactiveLimitsImpl(-1.7976931348623157E308, Double.MAX_VALUE));
        int variantArraySize = ref.get().getVariantManager().getVariantArraySize();
        this.targetP = new TDoubleArrayList(variantArraySize);
        this.targetQ = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.targetP.add(targetP);
            this.targetQ.add(targetQ);
        }
    }

    @Override
    protected String getTypeDescription() {
        return "Battery";
    }

    public double getTargetP() {
        return this.targetP.get(this.getNetwork().getVariantIndex());
    }

    public Battery setTargetP(double targetP) {
        NetworkImpl network = this.getNetwork();
        ValidationUtil.checkP0((Validable)this, (double)targetP, (ValidationLevel)network.getMinValidationLevel());
        int variantIndex = network.getVariantIndex();
        double oldValue = this.targetP.set(variantIndex, targetP);
        String variantId = network.getVariantManager().getVariantId(variantIndex);
        network.invalidateValidationLevel();
        this.notifyUpdate("targetP", variantId, (Object)oldValue, (Object)targetP);
        return this;
    }

    public double getTargetQ() {
        return this.targetQ.get(this.getNetwork().getVariantIndex());
    }

    public Battery setTargetQ(double targetQ) {
        NetworkImpl network = this.getNetwork();
        ValidationUtil.checkQ0((Validable)this, (double)targetQ, (ValidationLevel)network.getMinValidationLevel());
        int variantIndex = network.getVariantIndex();
        double oldValue = this.targetQ.set(variantIndex, targetQ);
        String variantId = network.getVariantManager().getVariantId(variantIndex);
        network.invalidateValidationLevel();
        this.notifyUpdate("targetQ", variantId, (Object)oldValue, (Object)targetQ);
        return this;
    }

    public double getMinP() {
        return this.minP;
    }

    public Battery setMinP(double minP) {
        ValidationUtil.checkMinP((Validable)this, (double)minP);
        ValidationUtil.checkActivePowerLimits((Validable)this, (double)minP, (double)this.maxP);
        double oldValue = this.minP;
        this.minP = minP;
        this.notifyUpdate("minP", (Object)oldValue, (Object)minP);
        return this;
    }

    public double getMaxP() {
        return this.maxP;
    }

    public Battery setMaxP(double maxP) {
        ValidationUtil.checkMaxP((Validable)this, (double)maxP);
        ValidationUtil.checkActivePowerLimits((Validable)this, (double)this.minP, (double)maxP);
        double oldValue = this.maxP;
        this.maxP = maxP;
        this.notifyUpdate("maxP", (Object)oldValue, (Object)maxP);
        return this;
    }

    public TerminalExt getTerminal() {
        return (TerminalExt)this.terminals.get(0);
    }

    public ReactiveLimits getReactiveLimits() {
        return this.reactiveLimits.getReactiveLimits();
    }

    @Override
    public void setReactiveLimits(ReactiveLimits reactiveLimits) {
        this.reactiveLimits.setReactiveLimits(reactiveLimits);
    }

    public <R extends ReactiveLimits> R getReactiveLimits(Class<R> type) {
        return this.reactiveLimits.getReactiveLimits(type);
    }

    public ReactiveCapabilityCurveAdder newReactiveCapabilityCurve() {
        return new ReactiveCapabilityCurveAdderImpl<BatteryImpl>(this);
    }

    public MinMaxReactiveLimitsAdder newMinMaxReactiveLimits() {
        return new MinMaxReactiveLimitsAdderImpl<BatteryImpl>(this);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.targetP.ensureCapacity(this.targetP.size() + number);
        this.targetQ.ensureCapacity(this.targetQ.size() + number);
        for (int i = 0; i < number; ++i) {
            this.targetP.add(this.targetP.get(sourceIndex));
            this.targetQ.add(this.targetQ.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.targetP.remove(this.targetP.size() - number, number);
        this.targetQ.remove(this.targetQ.size() - number, number);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.targetP.set(index, this.targetP.get(sourceIndex));
            this.targetQ.set(index, this.targetQ.get(sourceIndex));
        }
    }
}

