/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsAdderImpl;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ReactiveCapabilityCurveAdderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsHolderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsOwner;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.util.Ref;
import gnu.trove.list.array.TDoubleArrayList;

class GeneratorImpl
extends AbstractConnectable<Generator>
implements Generator,
ReactiveLimitsOwner {
    private final Ref<? extends VariantManagerHolder> network;
    private EnergySource energySource;
    private double minP;
    private double maxP;
    private double ratedS;
    private final ReactiveLimitsHolderImpl reactiveLimits;
    private final RegulatingPoint regulatingPoint;
    private final TDoubleArrayList targetP;
    private final TDoubleArrayList targetQ;
    private final TDoubleArrayList targetV;

    GeneratorImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious, EnergySource energySource, double minP, double maxP, boolean voltageRegulatorOn, TerminalExt regulatingTerminal, double targetP, double targetQ, double targetV, double ratedS) {
        super(network, id, name, fictitious);
        this.network = network;
        this.energySource = energySource;
        this.minP = minP;
        this.maxP = maxP;
        this.reactiveLimits = new ReactiveLimitsHolderImpl(this, (ReactiveLimits)new MinMaxReactiveLimitsImpl(-1.7976931348623157E308, Double.MAX_VALUE));
        this.ratedS = ratedS;
        int variantArraySize = network.get().getVariantManager().getVariantArraySize();
        this.regulatingPoint = new RegulatingPoint(id, this::getTerminal, variantArraySize, voltageRegulatorOn, voltageRegulatorOn);
        this.regulatingPoint.setRegulatingTerminal(regulatingTerminal);
        this.targetP = new TDoubleArrayList(variantArraySize);
        this.targetQ = new TDoubleArrayList(variantArraySize);
        this.targetV = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.targetP.add(targetP);
            this.targetQ.add(targetQ);
            this.targetV.add(targetV);
        }
    }

    public TerminalExt getTerminal() {
        return (TerminalExt)this.terminals.get(0);
    }

    public EnergySource getEnergySource() {
        return this.energySource;
    }

    public GeneratorImpl setEnergySource(EnergySource energySource) {
        ValidationUtil.checkEnergySource((Validable)this, (EnergySource)energySource);
        EnergySource oldValue = this.energySource;
        this.energySource = energySource;
        this.notifyUpdate("energySource", (Object)oldValue.toString(), (Object)energySource.toString());
        return this;
    }

    public double getMaxP() {
        return this.maxP;
    }

    public GeneratorImpl setMaxP(double maxP) {
        ValidationUtil.checkMaxP((Validable)this, (double)maxP);
        ValidationUtil.checkActivePowerLimits((Validable)this, (double)this.minP, (double)maxP);
        double oldValue = this.maxP;
        this.maxP = maxP;
        this.notifyUpdate("maxP", (Object)oldValue, (Object)maxP);
        return this;
    }

    public double getMinP() {
        return this.minP;
    }

    public GeneratorImpl setMinP(double minP) {
        ValidationUtil.checkMinP((Validable)this, (double)minP);
        ValidationUtil.checkActivePowerLimits((Validable)this, (double)minP, (double)this.maxP);
        double oldValue = this.minP;
        this.minP = minP;
        this.notifyUpdate("minP", (Object)oldValue, (Object)minP);
        return this;
    }

    public boolean isVoltageRegulatorOn() {
        return this.regulatingPoint.isRegulating(this.network.get().getVariantIndex());
    }

    public GeneratorImpl setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = this.network.get().getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)voltageRegulatorOn, (double)this.targetV.get(variantIndex), (double)this.targetQ.get(variantIndex), (ValidationLevel)n.getMinValidationLevel());
        boolean oldValue = this.regulatingPoint.setRegulating(variantIndex, voltageRegulatorOn);
        this.regulatingPoint.setUseVoltageRegulation(voltageRegulatorOn);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("voltageRegulatorOn", variantId, (Object)oldValue, (Object)voltageRegulatorOn);
        return this;
    }

    public TerminalExt getRegulatingTerminal() {
        return this.regulatingPoint.getRegulatingTerminal();
    }

    public GeneratorImpl setRegulatingTerminal(Terminal regulatingTerminal) {
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)regulatingTerminal, (Network)this.getNetwork());
        TerminalExt oldValue = this.regulatingPoint.getRegulatingTerminal();
        this.regulatingPoint.setRegulatingTerminal((TerminalExt)regulatingTerminal);
        this.notifyUpdate("regulatingTerminal", (Object)oldValue, (Object)regulatingTerminal);
        return this;
    }

    public double getTargetP() {
        return this.targetP.get(this.network.get().getVariantIndex());
    }

    public GeneratorImpl setTargetP(double targetP) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkActivePowerSetpoint((Validable)this, (double)targetP, (ValidationLevel)n.getMinValidationLevel());
        int variantIndex = this.network.get().getVariantIndex();
        double oldValue = this.targetP.set(this.network.get().getVariantIndex(), targetP);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("targetP", variantId, (Object)oldValue, (Object)targetP);
        return this;
    }

    public double getTargetQ() {
        return this.targetQ.get(this.network.get().getVariantIndex());
    }

    public GeneratorImpl setTargetQ(double targetQ) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = this.network.get().getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.regulatingPoint.isRegulating(variantIndex), (double)this.targetV.get(variantIndex), (double)targetQ, (ValidationLevel)n.getMinValidationLevel());
        double oldValue = this.targetQ.set(variantIndex, targetQ);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("targetQ", variantId, (Object)oldValue, (Object)targetQ);
        return this;
    }

    public double getTargetV() {
        return this.targetV.get(this.network.get().getVariantIndex());
    }

    public GeneratorImpl setTargetV(double targetV) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = this.network.get().getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.regulatingPoint.isRegulating(variantIndex), (double)targetV, (double)this.targetQ.get(variantIndex), (ValidationLevel)n.getMinValidationLevel());
        double oldValue = this.targetV.set(variantIndex, targetV);
        String variantId = this.network.get().getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("targetV", variantId, (Object)oldValue, (Object)targetV);
        return this;
    }

    public double getRatedS() {
        return this.ratedS;
    }

    public GeneratorImpl setRatedS(double ratedS) {
        ValidationUtil.checkRatedS((Validable)this, (double)ratedS);
        double oldValue = this.ratedS;
        this.ratedS = ratedS;
        this.notifyUpdate("ratedS", (Object)oldValue, (Object)ratedS);
        return this;
    }

    public ReactiveCapabilityCurveAdderImpl newReactiveCapabilityCurve() {
        return new ReactiveCapabilityCurveAdderImpl<GeneratorImpl>(this);
    }

    public MinMaxReactiveLimitsAdderImpl newMinMaxReactiveLimits() {
        return new MinMaxReactiveLimitsAdderImpl<GeneratorImpl>(this);
    }

    public ReactiveLimits getReactiveLimits() {
        return this.reactiveLimits.getReactiveLimits();
    }

    @Override
    public void setReactiveLimits(ReactiveLimits reactiveLimits) {
        this.reactiveLimits.setReactiveLimits(reactiveLimits);
    }

    public <RL extends ReactiveLimits> RL getReactiveLimits(Class<RL> type) {
        return this.reactiveLimits.getReactiveLimits(type);
    }

    @Override
    public void remove() {
        this.regulatingPoint.remove();
        super.remove();
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.targetP.ensureCapacity(this.targetP.size() + number);
        this.targetQ.ensureCapacity(this.targetQ.size() + number);
        this.targetV.ensureCapacity(this.targetV.size() + number);
        for (int i = 0; i < number; ++i) {
            this.targetP.add(this.targetP.get(sourceIndex));
            this.targetQ.add(this.targetQ.get(sourceIndex));
            this.targetV.add(this.targetV.get(sourceIndex));
        }
        this.regulatingPoint.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.targetP.remove(this.targetP.size() - number, number);
        this.targetQ.remove(this.targetQ.size() - number, number);
        this.targetV.remove(this.targetV.size() - number, number);
        this.regulatingPoint.reduceVariantArraySize(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.regulatingPoint.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.targetP.set(index, this.targetP.get(sourceIndex));
            this.targetQ.set(index, this.targetQ.get(sourceIndex));
            this.targetV.set(index, this.targetV.get(sourceIndex));
        }
        this.regulatingPoint.allocateVariantArrayElement(indexes, sourceIndex);
    }

    @Override
    protected String getTypeDescription() {
        return "Generator";
    }
}

