/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractHvdcConverterStation;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.HvdcLineImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.util.Ref;
import java.util.Objects;

public class HvdcLineAdderImpl
extends AbstractIdentifiableAdder<HvdcLineAdderImpl>
implements HvdcLineAdder {
    private final NetworkImpl network;
    private final String subnetwork;
    private double r = Double.NaN;
    private HvdcLine.ConvertersMode convertersMode;
    private double nominalV = Double.NaN;
    private double activePowerSetpoint = Double.NaN;
    private double maxP = Double.NaN;
    private String converterStationId1;
    private String converterStationId2;

    public HvdcLineAdderImpl(NetworkImpl network, String subnetwork) {
        this.network = Objects.requireNonNull(network);
        this.subnetwork = subnetwork;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.network;
    }

    @Override
    protected String getTypeDescription() {
        return "hvdcLine";
    }

    public HvdcLineAdder setR(double r) {
        this.r = r;
        return this;
    }

    public HvdcLineAdder setConvertersMode(HvdcLine.ConvertersMode convertersMode) {
        this.convertersMode = convertersMode;
        return this;
    }

    public HvdcLineAdder setNominalV(double nominalV) {
        this.nominalV = nominalV;
        return this;
    }

    public HvdcLineAdder setActivePowerSetpoint(double activePowerSetpoint) {
        this.activePowerSetpoint = activePowerSetpoint;
        return this;
    }

    public HvdcLineAdder setMaxP(double maxP) {
        this.maxP = maxP;
        return this;
    }

    public HvdcLineAdder setConverterStationId1(String converterStationId1) {
        this.converterStationId1 = converterStationId1;
        return this;
    }

    public HvdcLineAdder setConverterStationId2(String converterStationId2) {
        this.converterStationId2 = converterStationId2;
        return this;
    }

    public HvdcLine add() {
        String id = this.checkAndGetUniqueId();
        String name = this.getName();
        ValidationUtil.checkR((Validable)this, (double)this.r);
        this.network.setValidationLevelIfGreaterThan(ValidationUtil.checkConvertersMode((Validable)this, (HvdcLine.ConvertersMode)this.convertersMode, (this.network.getMinValidationLevel().compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) >= 0 ? 1 : 0) != 0));
        ValidationUtil.checkNominalV((Validable)this, (double)this.nominalV);
        this.network.setValidationLevelIfGreaterThan(ValidationUtil.checkHvdcActivePowerSetpoint((Validable)this, (double)this.activePowerSetpoint, (this.network.getMinValidationLevel().compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) >= 0 ? 1 : 0) != 0));
        ValidationUtil.checkHvdcMaxP((Validable)this, (double)this.maxP);
        HvdcConverterStation converterStation1 = this.network.getHvdcConverterStation(this.converterStationId1);
        if (converterStation1 == null) {
            throw new PowsyblException("Side 1 converter station " + this.converterStationId1 + " not found");
        }
        HvdcConverterStation converterStation2 = this.network.getHvdcConverterStation(this.converterStationId2);
        if (converterStation2 == null) {
            throw new PowsyblException("Side 2 converter station " + this.converterStationId2 + " not found");
        }
        VoltageLevelExt vl1 = converterStation1.getTerminal().getVoltageLevel();
        VoltageLevelExt vl2 = converterStation2.getTerminal().getVoltageLevel();
        if (!(this.subnetwork == null || this.subnetwork.equals(vl1.getSubnetworkId()) && this.subnetwork.equals(vl2.getSubnetworkId()))) {
            throw new ValidationException((Validable)this, "The converter stations are not in the subnetwork '" + this.subnetwork + "'. Create this Hvdc line from the parent network '" + this.getNetwork().getId() + "'");
        }
        Ref<NetworkImpl> networkRef = HvdcLineAdderImpl.computeNetworkRef(this.network, vl1, vl2);
        HvdcLineImpl hvdcLine = new HvdcLineImpl(id, name, this.isFictitious(), this.r, this.nominalV, this.maxP, this.convertersMode, this.activePowerSetpoint, (AbstractHvdcConverterStation<?>)converterStation1, (AbstractHvdcConverterStation<?>)converterStation2, networkRef);
        this.network.getIndex().checkAndAdd(hvdcLine);
        this.network.getListeners().notifyCreation(hvdcLine);
        return hvdcLine;
    }
}

