/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractHvdcConverterStationAdder;
import com.powsybl.iidm.network.impl.LccConverterStationImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

class LccConverterStationAdderImpl
extends AbstractHvdcConverterStationAdder<LccConverterStationAdderImpl>
implements LccConverterStationAdder {
    private float powerFactor = Float.NaN;

    LccConverterStationAdderImpl(VoltageLevelExt voltageLevel) {
        super(voltageLevel);
    }

    @Override
    protected String getTypeDescription() {
        return "lccConverterStation";
    }

    public LccConverterStationAdder setPowerFactor(float powerFactor) {
        this.powerFactor = powerFactor;
        return this;
    }

    public LccConverterStation add() {
        String id = this.checkAndGetUniqueId();
        String name = this.getName();
        TerminalExt terminal = this.checkAndGetTerminal();
        this.validate();
        LccConverterStationImpl converterStation = new LccConverterStationImpl(this.getNetworkRef(), id, name, this.isFictitious(), this.getLossFactor(), this.powerFactor);
        converterStation.addTerminal(terminal);
        this.getVoltageLevel().attach(terminal, false);
        this.getNetwork().getIndex().checkAndAdd(converterStation);
        this.getNetwork().getListeners().notifyCreation(converterStation);
        return converterStation;
    }

    @Override
    protected void validate() {
        super.validate();
        ValidationUtil.checkPowerFactor((Validable)this, (double)this.powerFactor);
    }
}

