/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.MinMaxReactiveLimits;
import com.powsybl.iidm.network.MinMaxReactiveLimitsAdder;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsOwner;

class MinMaxReactiveLimitsAdderImpl<OWNER extends ReactiveLimitsOwner & Validable>
implements MinMaxReactiveLimitsAdder {
    private final OWNER owner;
    private double minQ = Double.NaN;
    private double maxQ = Double.NaN;

    MinMaxReactiveLimitsAdderImpl(OWNER owner) {
        this.owner = owner;
    }

    public MinMaxReactiveLimitsAdder setMinQ(double minQ) {
        this.minQ = minQ;
        return this;
    }

    public MinMaxReactiveLimitsAdder setMaxQ(double maxQ) {
        this.maxQ = maxQ;
        return this;
    }

    public MinMaxReactiveLimits add() {
        if (Double.isNaN(this.minQ)) {
            throw new ValidationException((Validable)this.owner, "minimum reactive power is not set");
        }
        if (Double.isNaN(this.maxQ)) {
            throw new ValidationException((Validable)this.owner, "maximum reactive power is not set");
        }
        if (this.maxQ < this.minQ) {
            throw new ValidationException((Validable)this.owner, "maximum reactive power is expected to be greater than or equal to minimum reactive power");
        }
        MinMaxReactiveLimitsImpl limits = new MinMaxReactiveLimitsImpl(this.minQ, this.maxQ);
        this.owner.setReactiveLimits((ReactiveLimits)limits);
        return limits;
    }
}

