/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class NetworkIndex {
    private final Map<String, Identifiable<?>> objectsById = new HashMap();
    private final Map<String, String> idByAlias = new HashMap<String, String>();
    private final Map<Class<? extends Identifiable>, Set<Identifiable<?>>> objectsByClass = new HashMap();

    NetworkIndex() {
    }

    static void checkId(String id) {
        if (id == null || id.isEmpty()) {
            throw new PowsyblException("Invalid id '" + id + "'");
        }
    }

    static String getUniqueId() {
        return UUID.randomUUID().toString();
    }

    void checkAndAdd(Identifiable<?> obj) {
        NetworkIndex.checkId(obj.getId());
        if (this.objectsById.containsKey(obj.getId())) {
            throw new PowsyblException("Object (" + obj.getClass().getName() + ") '" + obj.getId() + "' already exists");
        }
        this.objectsById.put(obj.getId(), obj);
        obj.getAliases().forEach(alias -> this.addAlias(obj, (String)alias));
        Set<Identifiable<?>> all = this.objectsByClass.get(obj.getClass());
        if (all == null) {
            all = new LinkedHashSet();
            this.objectsByClass.put(obj.getClass(), all);
        }
        all.add(obj);
    }

    boolean addAlias(Identifiable<?> obj, String alias) {
        Identifiable<?> aliasConflict = this.objectsById.get(alias);
        if (aliasConflict != null) {
            if (aliasConflict.equals(obj)) {
                return false;
            }
            String message = String.format("Object (%s) with alias '%s' cannot be created because alias already refers to object (%s) with ID '%s'", obj.getClass(), alias, aliasConflict.getClass(), aliasConflict.getId());
            throw new PowsyblException(message);
        }
        String idForAlias = this.idByAlias.get(alias);
        if (idForAlias != null) {
            aliasConflict = this.objectsById.get(idForAlias);
            if (aliasConflict.equals(obj)) {
                return false;
            }
            String message = String.format("Object (%s) with alias '%s' cannot be created because alias already refers to object (%s) with ID '%s'", obj.getClass(), alias, aliasConflict.getClass(), aliasConflict.getId());
            throw new PowsyblException(message);
        }
        this.idByAlias.put(alias, obj.getId());
        return true;
    }

    public <I extends Identifiable<I>> void removeAlias(Identifiable<?> obj, String alias) {
        String idForAlias = this.idByAlias.get(alias);
        if (idForAlias == null) {
            throw new PowsyblException(String.format("No alias '%s' found in the network", alias));
        }
        if (!idForAlias.equals(obj.getId())) {
            throw new PowsyblException(String.format("Alias '%s' do not correspond to object '%s'", alias, obj.getId()));
        }
        this.idByAlias.remove(alias);
    }

    Identifiable get(String idOrAlias) {
        String id = this.idByAlias.getOrDefault(idOrAlias, idOrAlias);
        NetworkIndex.checkId(id);
        return this.objectsById.get(id);
    }

    <T extends Identifiable> T get(String id, Class<T> clazz) {
        Identifiable obj = this.get(id);
        if (obj != null && clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return null;
    }

    Collection<Identifiable<?>> getAll() {
        return this.objectsById.values();
    }

    <T extends Identifiable> Set<T> getAll(Class<T> clazz) {
        Set<Identifiable<?>> all = this.objectsByClass.get(clazz);
        if (all == null) {
            return Collections.emptySet();
        }
        return all;
    }

    boolean contains(String id) {
        String idFromPotentialAlias = this.idByAlias.getOrDefault(id, id);
        NetworkIndex.checkId(idFromPotentialAlias);
        return this.objectsById.containsKey(idFromPotentialAlias);
    }

    void remove(Identifiable obj) {
        NetworkIndex.checkId(obj.getId());
        Identifiable<?> old = this.objectsById.remove(obj.getId());
        if (old == null || old != obj) {
            throw new PowsyblException("Object (" + obj.getClass().getName() + ") '" + obj.getId() + "' not found");
        }
        obj.getAliases().forEach(this.idByAlias::remove);
        Set<Identifiable<?>> all = this.objectsByClass.get(obj.getClass());
        if (all != null) {
            all.remove(obj);
        }
    }

    void clean() {
        this.objectsById.clear();
        this.objectsByClass.clear();
    }

    Multimap<Class<? extends Identifiable>, String> intersection(NetworkIndex other) {
        HashMultimap intersection = HashMultimap.create();
        for (Map.Entry<Class<Identifiable>, Set<Identifiable<?>>> entry : other.objectsByClass.entrySet()) {
            Class<? extends Identifiable> clazz = entry.getKey();
            Set<Identifiable<?>> objects = entry.getValue();
            for (Identifiable<?> obj : objects) {
                if (this.objectsById.containsKey(obj.getId()) || this.idByAlias.containsKey(obj.getId())) {
                    intersection.put(clazz, (Object)obj.getId());
                }
                Set aliases = obj.getAliases();
                for (String alias : aliases) {
                    if (!this.objectsById.containsKey(alias) && !this.idByAlias.containsKey(alias)) continue;
                    intersection.put(clazz, (Object)alias);
                }
            }
        }
        return intersection;
    }

    void merge(NetworkIndex other) {
        for (Identifiable<?> obj : other.objectsById.values()) {
            this.checkAndAdd(obj);
        }
        other.clean();
    }

    void printForDebug(PrintStream out) {
        for (Map.Entry<String, Identifiable<?>> entry : this.objectsById.entrySet()) {
            out.println(entry.getKey() + " " + System.identityHashCode(entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : this.objectsByClass.entrySet()) {
            out.println(entry.getKey() + " " + ((Set)entry.getValue()).stream().map(System::identityHashCode).toList());
        }
    }
}

