/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.ActivePowerLimitsAdderImpl;
import com.powsybl.iidm.network.impl.ApparentPowerLimitsAdderImpl;
import com.powsybl.iidm.network.impl.CurrentLimitsAdderImpl;
import com.powsybl.iidm.network.impl.OperationalLimitsGroupImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

class OperationalLimitsGroupsImpl
implements FlowsLimitsHolder {
    private static final String DEFAULT_SELECTED_OPERATIONAL_LIMITS_GROUP_ID = "DEFAULT";
    private final String attributeName;
    private String selectedLimitsId = null;
    private final Map<String, OperationalLimitsGroupImpl> operationalLimitsGroupById = new LinkedHashMap<String, OperationalLimitsGroupImpl>();
    private final AbstractIdentifiable<?> identifiable;

    OperationalLimitsGroupsImpl(AbstractIdentifiable<?> identifiable, String attributeName) {
        this.identifiable = Objects.requireNonNull(identifiable);
        this.attributeName = attributeName;
    }

    public OperationalLimitsGroupImpl newOperationalLimitsGroup(String id) {
        Objects.requireNonNull(id);
        OperationalLimitsGroupImpl newLimits = new OperationalLimitsGroupImpl(id, this.identifiable, this.attributeName, this.selectedLimitsId);
        OperationalLimitsGroup oldLimits = this.operationalLimitsGroupById.put(id, newLimits);
        if (id.equals(this.selectedLimitsId)) {
            this.notifyUpdate(oldLimits, newLimits);
        }
        return newLimits;
    }

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup(String id) {
        return this.getOperationalLimitsGroupImpl(id).map(Function.identity());
    }

    private Optional<OperationalLimitsGroupImpl> getOperationalLimitsGroupImpl(String id) {
        Objects.requireNonNull(id);
        return Optional.ofNullable(this.operationalLimitsGroupById.get(id));
    }

    public void removeOperationalLimitsGroup(String id) {
        Objects.requireNonNull(id);
        OperationalLimitsGroup oldLimits = this.operationalLimitsGroupById.remove(id);
        if (id.equals(this.selectedLimitsId)) {
            this.setSelectedOperationalLimitsGroupNullableId(null);
            this.notifyUpdate(oldLimits, null);
        }
    }

    public void setSelectedOperationalLimitsGroup(String id) {
        this.setSelectedOperationalLimitsGroupNullableId(Objects.requireNonNull(id));
    }

    private void setSelectedOperationalLimitsGroupNullableId(String id) {
        if (Objects.equals(id, this.selectedLimitsId)) {
            return;
        }
        this.operationalLimitsGroupById.values().forEach(o -> o.setSelectedGroupId(id));
        OperationalLimitsGroup newDefaultLimits = id == null ? null : this.getOperationalLimitsGroup(id).orElseThrow(() -> new PowsyblException("No operational limits group is associated to id " + id + " so this id can't be the default one"));
        Optional<OperationalLimitsGroup> oldDefaultLimits = this.getSelectedOperationalLimitsGroup();
        this.selectedLimitsId = id;
        oldDefaultLimits.ifPresent(olg -> this.notifyUpdate((OperationalLimitsGroup)olg, newDefaultLimits));
    }

    public void cancelSelectedOperationalLimitsGroup() {
        this.setSelectedOperationalLimitsGroupNullableId(null);
    }

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup() {
        return this.getSelectedOperationalLimitsGroupImpl().map(Function.identity());
    }

    private Optional<OperationalLimitsGroupImpl> getSelectedOperationalLimitsGroupImpl() {
        return Optional.ofNullable(this.selectedLimitsId).flatMap(this::getOperationalLimitsGroupImpl);
    }

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups() {
        return Collections.unmodifiableCollection(this.operationalLimitsGroupById.values());
    }

    public Optional<String> getSelectedOperationalLimitsGroupId() {
        return Optional.ofNullable(this.selectedLimitsId);
    }

    private OperationalLimitsGroupImpl getOrCreateSelectedOperationalLimitsGroup() {
        return this.getSelectedOperationalLimitsGroupImpl().orElseGet(() -> {
            String groupId = DEFAULT_SELECTED_OPERATIONAL_LIMITS_GROUP_ID;
            OperationalLimitsGroupImpl group = Optional.ofNullable(this.operationalLimitsGroupById.get(groupId)).orElseGet(() -> this.newOperationalLimitsGroup(groupId));
            this.setSelectedOperationalLimitsGroup(groupId);
            return group;
        });
    }

    public CurrentLimitsAdder newCurrentLimits() {
        return new CurrentLimitsAdderImpl(this::getOrCreateSelectedOperationalLimitsGroup, this.identifiable, this.identifiable.getId());
    }

    public ActivePowerLimitsAdder newActivePowerLimits() {
        return new ActivePowerLimitsAdderImpl(this::getOrCreateSelectedOperationalLimitsGroup, this.identifiable, this.identifiable.getId());
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits() {
        return new ApparentPowerLimitsAdderImpl(this::getOrCreateSelectedOperationalLimitsGroup, this.identifiable, this.identifiable.getId());
    }

    private void notifyUpdate(OperationalLimitsGroup oldValue, OperationalLimitsGroup newValue) {
        CurrentLimits oldCurrentValue = Optional.ofNullable(oldValue).flatMap(OperationalLimitsGroup::getCurrentLimits).orElse(null);
        CurrentLimits newCurrentValue = Optional.ofNullable(newValue).flatMap(OperationalLimitsGroup::getCurrentLimits).orElse(null);
        this.identifiable.getNetwork().getListeners().notifyUpdate(this.identifiable, this.attributeName + "_" + LimitType.CURRENT, (Object)oldCurrentValue, (Object)newCurrentValue);
        ActivePowerLimits oldActivePowerLimits = Optional.ofNullable(oldValue).flatMap(OperationalLimitsGroup::getActivePowerLimits).orElse(null);
        ActivePowerLimits newActivePowerLimits = Optional.ofNullable(newValue).flatMap(OperationalLimitsGroup::getActivePowerLimits).orElse(null);
        this.identifiable.getNetwork().getListeners().notifyUpdate(this.identifiable, this.attributeName + "_" + LimitType.ACTIVE_POWER, (Object)oldActivePowerLimits, (Object)newActivePowerLimits);
        ApparentPowerLimits oldApparentPowerLimits = Optional.ofNullable(oldValue).flatMap(OperationalLimitsGroup::getApparentPowerLimits).orElse(null);
        ApparentPowerLimits newApparentPowerLimits = Optional.ofNullable(newValue).flatMap(OperationalLimitsGroup::getApparentPowerLimits).orElse(null);
        this.identifiable.getNetwork().getListeners().notifyUpdate(this.identifiable, this.attributeName + "_" + LimitType.APPARENT_POWER, (Object)oldApparentPowerLimits, (Object)newApparentPowerLimits);
    }
}

