/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.reporter.Report;
import com.powsybl.commons.reporter.TypedValue;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerParent;
import com.powsybl.iidm.network.impl.RatioTapChangerStepImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RatioTapChangerAdderImpl
implements RatioTapChangerAdder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RatioTapChangerAdderImpl.class);
    private final RatioTapChangerParent parent;
    private int lowTapPosition = 0;
    private Integer tapPosition;
    private final List<RatioTapChangerStepImpl> steps = new ArrayList<RatioTapChangerStepImpl>();
    private boolean loadTapChangingCapabilities = false;
    private boolean regulating = false;
    private RatioTapChanger.RegulationMode regulationMode = null;
    private double regulationValue = Double.NaN;
    private double targetDeadband = Double.NaN;
    private TerminalExt regulationTerminal;

    RatioTapChangerAdderImpl(RatioTapChangerParent parent) {
        this.parent = parent;
    }

    NetworkImpl getNetwork() {
        return this.parent.getNetwork();
    }

    public RatioTapChangerAdder setLowTapPosition(int lowTapPosition) {
        this.lowTapPosition = lowTapPosition;
        return this;
    }

    public RatioTapChangerAdder setTapPosition(int tapPosition) {
        this.tapPosition = tapPosition;
        return this;
    }

    public RatioTapChangerAdder setLoadTapChangingCapabilities(boolean loadTapChangingCapabilities) {
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
        return this;
    }

    public RatioTapChangerAdder setRegulating(boolean regulating) {
        this.regulating = regulating;
        return this;
    }

    public RatioTapChangerAdder setTargetV(double targetV) {
        if (!Double.isNaN(targetV)) {
            this.regulationMode = RatioTapChanger.RegulationMode.VOLTAGE;
        }
        this.regulationValue = targetV;
        return this;
    }

    public RatioTapChangerAdder setRegulationMode(RatioTapChanger.RegulationMode regulationMode) {
        this.regulationMode = regulationMode;
        return this;
    }

    public RatioTapChangerAdder setRegulationValue(double regulationValue) {
        this.regulationValue = regulationValue;
        return this;
    }

    public RatioTapChangerAdder setTargetDeadband(double targetDeadband) {
        this.targetDeadband = targetDeadband;
        return this;
    }

    public RatioTapChangerAdder setRegulationTerminal(Terminal regulationTerminal) {
        this.regulationTerminal = (TerminalExt)regulationTerminal;
        return this;
    }

    public RatioTapChangerAdder.StepAdder beginStep() {
        return new StepAdderImpl();
    }

    public RatioTapChanger add() {
        NetworkImpl network = this.getNetwork();
        if (this.tapPosition == null) {
            ValidationUtil.throwExceptionOrLogError((Validable)this.parent, (String)"tap position is not set", (ValidationLevel)network.getMinValidationLevel());
            network.setValidationLevelIfGreaterThan(ValidationLevel.EQUIPMENT);
        }
        if (this.steps.isEmpty()) {
            throw new ValidationException((Validable)this.parent, "ratio tap changer should have at least one step");
        }
        if (this.tapPosition != null) {
            int highTapPosition = this.lowTapPosition + this.steps.size() - 1;
            if (this.tapPosition < this.lowTapPosition || this.tapPosition > highTapPosition) {
                ValidationUtil.throwExceptionOrLogError((Validable)this.parent, (String)("incorrect tap position " + this.tapPosition + " [" + this.lowTapPosition + ", " + highTapPosition + "]"), (ValidationLevel)network.getMinValidationLevel());
                network.setValidationLevelIfGreaterThan(ValidationLevel.EQUIPMENT);
            }
        }
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.regulating, (boolean)this.loadTapChangingCapabilities, (Terminal)this.regulationTerminal, (RatioTapChanger.RegulationMode)this.regulationMode, (double)this.regulationValue, (Network)network, (ValidationLevel)network.getMinValidationLevel()));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkTargetDeadband((Validable)this.parent, (String)"ratio tap changer", (boolean)this.regulating, (double)this.targetDeadband, (ValidationLevel)network.getMinValidationLevel()));
        RatioTapChangerImpl tapChanger = new RatioTapChangerImpl(this.parent, this.lowTapPosition, this.steps, this.regulationTerminal, this.loadTapChangingCapabilities, this.tapPosition, this.regulating, this.regulationMode, this.regulationValue, this.targetDeadband);
        HashSet tapChangers = new HashSet(this.parent.getAllTapChangers());
        tapChangers.remove(this.parent.getRatioTapChanger());
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkOnlyOneTapChangerRegulatingEnabled((Validable)this.parent, tapChangers, (boolean)this.regulating, (network.getMinValidationLevel().compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) >= 0 ? 1 : 0) != 0));
        if (this.parent.hasPhaseTapChanger()) {
            LOGGER.warn("{} has both Ratio and Phase Tap Changer", (Object)this.parent);
            network.getReporterContext().getReporter().report(Report.builder().withKey("validationWarning").withDefaultMessage("${parent} has both Ratio and Phase Tap Changer.").withValue("parent", this.parent.getMessageHeader()).withSeverity(TypedValue.WARN_SEVERITY).build());
        }
        this.parent.setRatioTapChanger(tapChanger);
        return tapChanger;
    }

    class StepAdderImpl
    implements RatioTapChangerAdder.StepAdder {
        private double rho = Double.NaN;
        private double r = 0.0;
        private double x = 0.0;
        private double g = 0.0;
        private double b = 0.0;

        StepAdderImpl() {
        }

        public RatioTapChangerAdder.StepAdder setRho(double rho) {
            this.rho = rho;
            return this;
        }

        public RatioTapChangerAdder.StepAdder setR(double r) {
            this.r = r;
            return this;
        }

        public RatioTapChangerAdder.StepAdder setX(double x) {
            this.x = x;
            return this;
        }

        public RatioTapChangerAdder.StepAdder setG(double g) {
            this.g = g;
            return this;
        }

        public RatioTapChangerAdder.StepAdder setB(double b) {
            this.b = b;
            return this;
        }

        public RatioTapChangerAdder endStep() {
            RatioTapChangerStepImpl step = new RatioTapChangerStepImpl(RatioTapChangerAdderImpl.this.steps.size(), this.rho, this.r, this.x, this.g, this.b);
            step.validate(RatioTapChangerAdderImpl.this.parent);
            RatioTapChangerAdderImpl.this.steps.add(step);
            return RatioTapChangerAdderImpl.this;
        }
    }
}

