/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.reporter.Report;
import com.powsybl.commons.reporter.TypedValue;
import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import com.powsybl.iidm.network.ReactiveCapabilityCurveAdder;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.ReactiveCapabilityCurveImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsOwner;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReactiveCapabilityCurveAdderImpl<OWNER extends ReactiveLimitsOwner & Validable>
implements ReactiveCapabilityCurveAdder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveCapabilityCurveAdderImpl.class);
    private final OWNER owner;
    private final TreeMap<Double, ReactiveCapabilityCurve.Point> points = new TreeMap();

    ReactiveCapabilityCurveAdderImpl(OWNER owner) {
        this.owner = owner;
    }

    public PointAdderImpl beginPoint() {
        return new PointAdderImpl();
    }

    public ReactiveCapabilityCurve add() {
        if (this.points.size() < 2) {
            throw new ValidationException((Validable)this.owner, "a reactive capability curve should have at least two points");
        }
        ReactiveCapabilityCurveImpl curve = new ReactiveCapabilityCurveImpl(this.points);
        this.owner.setReactiveLimits((ReactiveLimits)curve);
        return curve;
    }

    private class PointAdderImpl
    implements ReactiveCapabilityCurveAdder.PointAdder {
        private double p = Double.NaN;
        private double minQ = Double.NaN;
        private double maxQ = Double.NaN;

        private PointAdderImpl() {
        }

        public ReactiveCapabilityCurveAdder.PointAdder setP(double p) {
            this.p = p;
            return this;
        }

        public ReactiveCapabilityCurveAdder.PointAdder setMinQ(double minQ) {
            this.minQ = minQ;
            return this;
        }

        public ReactiveCapabilityCurveAdder.PointAdder setMaxQ(double maxQ) {
            this.maxQ = maxQ;
            return this;
        }

        public ReactiveCapabilityCurveAdder endPoint() {
            if (Double.isNaN(this.p)) {
                throw new ValidationException((Validable)ReactiveCapabilityCurveAdderImpl.this.owner, "P is not set");
            }
            if (Double.isNaN(this.minQ)) {
                throw new ValidationException((Validable)ReactiveCapabilityCurveAdderImpl.this.owner, "min Q is not set");
            }
            if (Double.isNaN(this.maxQ)) {
                throw new ValidationException((Validable)ReactiveCapabilityCurveAdderImpl.this.owner, "max Q is not set");
            }
            ReactiveCapabilityCurve.Point point = ReactiveCapabilityCurveAdderImpl.this.points.get(this.p);
            if (point != null) {
                if (point.getMinQ() != this.minQ || point.getMaxQ() != this.maxQ) {
                    throw new ValidationException((Validable)ReactiveCapabilityCurveAdderImpl.this.owner, "a point already exists for active power " + this.p + " with a different reactive power range: [" + this.minQ + ", " + this.maxQ + "] != [" + point.getMinQ() + ", " + point.getMaxQ() + "]");
                }
                LOGGER.warn("{}duplicate point for active power {}", (Object)((Validable)ReactiveCapabilityCurveAdderImpl.this.owner).getMessageHeader(), (Object)this.p);
                ReactiveCapabilityCurveAdderImpl.this.owner.getNetwork().getReporterContext().getReporter().report(Report.builder().withKey("validationWarning").withDefaultMessage("${parent} duplicate point for active power {p}").withValue("parent", ((Validable)ReactiveCapabilityCurveAdderImpl.this.owner).getMessageHeader()).withValue("p", this.p).withSeverity(TypedValue.WARN_SEVERITY).build());
            }
            ReactiveCapabilityCurveAdderImpl.this.points.put(this.p, new ReactiveCapabilityCurveImpl.PointImpl(this.p, this.minQ, this.maxQ));
            return ReactiveCapabilityCurveAdderImpl.this;
        }
    }
}

