/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.AutomationSystem;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.ContainerType;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.OverloadManagementSystemAdderImpl;
import com.powsybl.iidm.network.impl.OverloadManagementSystemImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.Substations;
import com.powsybl.iidm.network.impl.ThreeWindingsTransformerAdderImpl;
import com.powsybl.iidm.network.impl.TwoWindingsTransformerAdderImpl;
import com.powsybl.iidm.network.impl.VoltageLevelAdderImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.VoltageLevels;
import com.powsybl.iidm.network.impl.util.Ref;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

class SubstationImpl
extends AbstractIdentifiable<Substation>
implements Substation {
    private Country country;
    private String tso;
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private final Set<String> geographicalTags = new LinkedHashSet<String>();
    private final Set<VoltageLevelExt> voltageLevels = new LinkedHashSet<VoltageLevelExt>();
    private final Set<OverloadManagementSystemImpl> overloadManagementSystems = new LinkedHashSet<OverloadManagementSystemImpl>();
    private boolean removed = false;

    SubstationImpl(String id, String name, boolean fictitious, Country country, String tso, Ref<NetworkImpl> networkRef, Ref<SubnetworkImpl> subnetworkRef) {
        super(id, name, fictitious);
        this.country = country;
        this.tso = tso;
        this.networkRef = networkRef;
        this.subnetworkRef = subnetworkRef;
    }

    Ref<SubnetworkImpl> getSubnetworkRef() {
        return this.subnetworkRef;
    }

    public ContainerType getContainerType() {
        return ContainerType.SUBSTATION;
    }

    public Optional<Country> getCountry() {
        return Optional.ofNullable(this.country);
    }

    public Country getNullableCountry() {
        return this.country;
    }

    public SubstationImpl setCountry(Country country) {
        String oldValue = Optional.ofNullable(this.country).map(Enum::toString).orElse("");
        this.country = country;
        this.getNetwork().getListeners().notifyUpdate(this, "country", (Object)oldValue, (Object)Optional.ofNullable(country).map(Enum::toString).orElse(""));
        return this;
    }

    public String getTso() {
        return this.tso;
    }

    public SubstationImpl setTso(String tso) {
        String oldValue = this.tso;
        this.tso = tso;
        this.getNetwork().getListeners().notifyUpdate(this, "tso", (Object)oldValue, (Object)tso);
        return this;
    }

    @Override
    public NetworkImpl getNetwork() {
        if (this.removed) {
            throw new PowsyblException("Cannot access network of removed substation " + this.id);
        }
        return this.networkRef.get();
    }

    protected Ref<NetworkImpl> getNetworkRef() {
        return this.networkRef;
    }

    public Network getParentNetwork() {
        return Optional.ofNullable((Network)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    void addVoltageLevel(VoltageLevelExt voltageLevel) {
        this.voltageLevels.add(voltageLevel);
    }

    public VoltageLevelAdderImpl newVoltageLevel() {
        return new VoltageLevelAdderImpl(this);
    }

    public Iterable<VoltageLevel> getVoltageLevels() {
        return Collections.unmodifiableSet(this.voltageLevels);
    }

    public Stream<VoltageLevel> getVoltageLevelStream() {
        return this.voltageLevels.stream().map(Function.identity());
    }

    public TwoWindingsTransformerAdderImpl newTwoWindingsTransformer() {
        return new TwoWindingsTransformerAdderImpl(this);
    }

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers() {
        return FluentIterable.from(this.voltageLevels).transformAndConcat(vl -> vl.getConnectables(TwoWindingsTransformer.class)).toSet();
    }

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream() {
        return this.voltageLevels.stream().flatMap(vl -> vl.getConnectableStream(TwoWindingsTransformer.class)).distinct();
    }

    public int getTwoWindingsTransformerCount() {
        return Ints.checkedCast((long)this.getTwoWindingsTransformerStream().count());
    }

    public ThreeWindingsTransformerAdderImpl newThreeWindingsTransformer() {
        return new ThreeWindingsTransformerAdderImpl(this);
    }

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers() {
        return FluentIterable.from(this.voltageLevels).transformAndConcat(vl -> vl.getConnectables(ThreeWindingsTransformer.class)).toSet();
    }

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream() {
        return this.voltageLevels.stream().flatMap(vl -> vl.getConnectableStream(ThreeWindingsTransformer.class)).distinct();
    }

    public int getThreeWindingsTransformerCount() {
        return Ints.checkedCast((long)this.getThreeWindingsTransformerStream().count());
    }

    void addOverloadManagementSystem(OverloadManagementSystemImpl overloadManagementSystem) {
        this.overloadManagementSystems.add(overloadManagementSystem);
    }

    public OverloadManagementSystemAdderImpl newOverloadManagementSystem() {
        return new OverloadManagementSystemAdderImpl(this);
    }

    public Iterable<OverloadManagementSystem> getOverloadManagementSystems() {
        return Collections.unmodifiableSet(this.overloadManagementSystems);
    }

    public Stream<OverloadManagementSystem> getOverloadManagementSystemStream() {
        return this.overloadManagementSystems.stream().map(Function.identity());
    }

    public int getOverloadManagementSystemCount() {
        return Ints.checkedCast((long)this.getOverloadManagementSystemStream().count());
    }

    public Set<String> getGeographicalTags() {
        return Collections.unmodifiableSet(this.geographicalTags);
    }

    public Substation addGeographicalTag(String tag) {
        if (tag == null) {
            throw new ValidationException((Validable)this, "geographical tag is null");
        }
        if (this.geographicalTags.add(tag)) {
            this.getNetwork().getListeners().notifyElementAdded(this, "geographicalTags", (Object)tag);
        }
        return this;
    }

    @Override
    protected String getTypeDescription() {
        return "Substation";
    }

    public void remove() {
        Substations.checkRemovability(this);
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        HashSet<VoltageLevelExt> vls = new HashSet<VoltageLevelExt>(this.voltageLevels);
        for (VoltageLevelExt vl : vls) {
            ArrayList connectables = Lists.newArrayList((Iterable)vl.getConnectables());
            for (Connectable connectable : connectables) {
                HvdcLine hvdcLine;
                IdentifiableType type = connectable.getType();
                if (VoltageLevels.MULTIPLE_TERMINALS_CONNECTABLE_TYPES.contains(type)) {
                    connectable.remove();
                    continue;
                }
                if (type != IdentifiableType.HVDC_CONVERTER_STATION || (hvdcLine = this.getNetwork().getHvdcLine((HvdcConverterStation)connectable)) == null) continue;
                hvdcLine.remove();
            }
            vl.remove();
        }
        this.removeOverloadManagementSystems();
        network.getIndex().remove(this);
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
    }

    void removeOverloadManagementSystems() {
        this.overloadManagementSystems.forEach(AutomationSystem::remove);
    }

    void remove(OverloadManagementSystemImpl overloadManagementSystem) {
        Objects.requireNonNull(overloadManagementSystem);
        this.overloadManagementSystems.remove(overloadManagementSystem);
    }

    void remove(VoltageLevelExt voltageLevelExt) {
        Objects.requireNonNull(voltageLevelExt);
        this.voltageLevels.remove(voltageLevelExt);
    }
}

