/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.DanglingLineImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TieLineImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.util.Ref;
import java.util.Objects;

class TieLineAdderImpl
extends AbstractIdentifiableAdder<TieLineAdderImpl>
implements TieLineAdder {
    private final NetworkImpl network;
    private final String subnetwork;
    private String dl1Id;
    private String dl2Id;

    TieLineAdderImpl(NetworkImpl network, String subnetwork) {
        this.network = Objects.requireNonNull(network);
        this.subnetwork = subnetwork;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.network;
    }

    @Override
    protected String getTypeDescription() {
        return "AC tie Line";
    }

    public TieLineAdderImpl setDanglingLine1(String dl1Id) {
        this.dl1Id = dl1Id;
        return this;
    }

    public TieLineAdderImpl setDanglingLine2(String dl2Id) {
        this.dl2Id = dl2Id;
        return this;
    }

    public TieLineImpl add() {
        String id = this.checkAndGetUniqueId();
        if (this.dl1Id == null || this.dl2Id == null) {
            throw new ValidationException((Validable)this, "undefined dangling line");
        }
        DanglingLineImpl dl1 = this.network.getDanglingLine(this.dl1Id);
        DanglingLineImpl dl2 = this.network.getDanglingLine(this.dl2Id);
        if (dl1 == null || dl2 == null) {
            throw new ValidationException((Validable)this, this.dl1Id + " and/or " + this.dl2Id + " are not dangling lines in the network");
        }
        if (dl1 == dl2) {
            throw new ValidationException((Validable)this, "danglingLine1 and danglingLine2 are identical (" + dl1.getId() + ")");
        }
        if (dl1.getTieLine().isPresent() || dl2.getTieLine().isPresent()) {
            throw new ValidationException((Validable)this, "danglingLine1 (" + this.dl1Id + ") and/or danglingLine2 (" + this.dl2Id + ") already has a tie line");
        }
        if (dl1.getPairingKey() != null && dl2.getPairingKey() != null && !Objects.equals(dl1.getPairingKey(), dl2.getPairingKey())) {
            throw new ValidationException((Validable)this, "pairingKey is not consistent");
        }
        VoltageLevelExt voltageLevel1 = dl1.getTerminal().getVoltageLevel();
        VoltageLevelExt voltageLevel2 = dl2.getTerminal().getVoltageLevel();
        if (!(this.subnetwork == null || this.subnetwork.equals(voltageLevel1.getSubnetworkId()) && this.subnetwork.equals(voltageLevel2.getSubnetworkId()))) {
            throw new ValidationException((Validable)this, "The involved dangling lines are not in the subnetwork '" + this.subnetwork + "'. Create this tie line from the parent network '" + this.getNetwork().getId() + "'");
        }
        Ref<NetworkImpl> networkRef = TieLineAdderImpl.computeNetworkRef(this.network, voltageLevel1, voltageLevel2);
        TieLineImpl line = new TieLineImpl(networkRef, id, this.getName(), this.isFictitious());
        line.attachDanglingLines(dl1, dl2);
        this.getNetwork().getConnectedComponentsManager().invalidate();
        this.getNetwork().getSynchronousComponentsManager().invalidate();
        this.network.getIndex().checkAndAdd(line);
        this.network.getListeners().notifyCreation(line);
        return line;
    }
}

