/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.extensions.DiscreteMeasurement;
import com.powsybl.iidm.network.extensions.DiscreteMeasurementAdder;
import com.powsybl.iidm.network.extensions.util.DiscreteMeasurementValidationUtil;
import com.powsybl.iidm.network.impl.extensions.DiscreteMeasurementImpl;
import com.powsybl.iidm.network.impl.extensions.DiscreteMeasurementsImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class DiscreteMeasurementAdderImpl
implements DiscreteMeasurementAdder {
    private final DiscreteMeasurementsImpl<? extends Identifiable<?>> discreteMeasurements;
    private final Map<String, String> properties = new HashMap<String, String>();
    private String id;
    private boolean idUnicity = false;
    private DiscreteMeasurement.Type type;
    private DiscreteMeasurement.TapChanger tapChanger;
    private Object value = null;
    private boolean valid = true;

    DiscreteMeasurementAdderImpl(DiscreteMeasurementsImpl<? extends Identifiable<?>> discreteMeasurements) {
        this.discreteMeasurements = Objects.requireNonNull(discreteMeasurements);
    }

    public DiscreteMeasurementAdder setId(String id) {
        this.id = id;
        return this;
    }

    public DiscreteMeasurementAdder putProperty(String name, String value) {
        this.properties.put(Objects.requireNonNull(name), value);
        return this;
    }

    public DiscreteMeasurementAdder setType(DiscreteMeasurement.Type type) {
        this.type = type;
        return this;
    }

    public DiscreteMeasurementAdder setTapChanger(DiscreteMeasurement.TapChanger tapChanger) {
        this.tapChanger = tapChanger;
        return this;
    }

    public DiscreteMeasurementAdder setValue(String value) {
        this.value = value;
        return this;
    }

    public DiscreteMeasurementAdder setValue(boolean value) {
        this.value = value;
        return this;
    }

    public DiscreteMeasurementAdder setValue(int value) {
        this.value = value;
        return this;
    }

    public DiscreteMeasurementAdder setValid(boolean valid) {
        this.valid = valid;
        return this;
    }

    public DiscreteMeasurementAdder setEnsureIdUnicity(boolean idUnicity) {
        this.idUnicity = idUnicity;
        return this;
    }

    public DiscreteMeasurement add() {
        this.id = DiscreteMeasurementValidationUtil.checkId((String)this.id, (boolean)this.idUnicity, this.discreteMeasurements);
        DiscreteMeasurementValidationUtil.checkType((DiscreteMeasurement.Type)this.type, (Identifiable)((Identifiable)this.discreteMeasurements.getExtendable()));
        DiscreteMeasurementValidationUtil.checkTapChanger((DiscreteMeasurement.TapChanger)this.tapChanger, (DiscreteMeasurement.Type)this.type, (Identifiable)((Identifiable)this.discreteMeasurements.getExtendable()));
        DiscreteMeasurementValidationUtil.checkValue((Object)this.value, (boolean)this.valid);
        DiscreteMeasurementImpl discreteMeasurement = new DiscreteMeasurementImpl(this.discreteMeasurements, this.id, this.type, this.tapChanger, this.properties, DiscreteMeasurementValidationUtil.getValueType((Object)this.value), this.value, this.valid);
        this.discreteMeasurements.add(discreteMeasurement);
        return discreteMeasurement;
    }
}

