/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.extensions.Measurement;
import com.powsybl.iidm.network.extensions.MeasurementAdder;
import com.powsybl.iidm.network.extensions.Measurements;
import com.powsybl.iidm.network.impl.extensions.MeasurementAdderImpl;
import com.powsybl.iidm.network.impl.extensions.MeasurementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class MeasurementsImpl<C extends Connectable<C>>
extends AbstractExtension<C>
implements Measurements<C> {
    private final List<MeasurementImpl> measurements = new ArrayList<MeasurementImpl>();

    MeasurementsImpl() {
    }

    MeasurementsImpl<C> add(MeasurementImpl measurement) {
        this.measurements.add(measurement);
        return this;
    }

    void remove(MeasurementImpl measurement) {
        this.measurements.remove(measurement);
    }

    public Collection<Measurement> getMeasurements() {
        return Collections.unmodifiableList(this.measurements);
    }

    public Collection<Measurement> getMeasurements(Measurement.Type type) {
        return this.measurements.stream().filter(m -> m.getType() == type).collect(Collectors.toList());
    }

    public Measurement getMeasurement(String id) {
        return this.measurements.stream().filter(a -> a.getId() != null && a.getId().equals(id)).findFirst().orElse(null);
    }

    public MeasurementAdder newMeasurement() {
        return new MeasurementAdderImpl(this);
    }
}

