/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractLoadingLimits;
import com.powsybl.iidm.network.impl.NetworkImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLoadingLimitsAdder<L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>>
implements LoadingLimitsAdder<L, A> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLoadingLimitsAdder.class);
    private static final Comparator<Integer> ACCEPTABLE_DURATION_COMPARATOR = (acceptableDuration1, acceptableDuration2) -> acceptableDuration2 - acceptableDuration1;
    protected final Validable validable;
    private final String ownerId;
    protected double permanentLimit = Double.NaN;
    protected final TreeMap<Integer, LoadingLimits.TemporaryLimit> temporaryLimits = new TreeMap(ACCEPTABLE_DURATION_COMPARATOR);

    AbstractLoadingLimitsAdder(Validable validable, String ownerId) {
        this.validable = Objects.requireNonNull(validable);
        this.ownerId = ownerId;
    }

    public A setPermanentLimit(double permanentLimit) {
        this.permanentLimit = permanentLimit;
        return (A)this;
    }

    public LoadingLimitsAdder.TemporaryLimitAdder<A> beginTemporaryLimit() {
        return new TemporaryLimitAdderImpl();
    }

    public double getPermanentLimit() {
        return this.permanentLimit;
    }

    public double getTemporaryLimitValue(int acceptableDuration) {
        return Optional.ofNullable(this.temporaryLimits.get(acceptableDuration)).map(LoadingLimits.TemporaryLimit::getValue).orElse(Double.NaN);
    }

    public boolean hasTemporaryLimits() {
        return !this.temporaryLimits.isEmpty();
    }

    protected void checkAndUpdateValidationLevel(NetworkImpl network) {
        network.setValidationLevelIfGreaterThan(this.checkLoadingLimits(network.getMinValidationLevel(), network.getReportNodeContext().getReportNode()));
    }

    protected ValidationLevel checkLoadingLimits(ValidationLevel validationLevel, ReportNode reportNode) {
        return ValidationUtil.checkLoadingLimits((Validable)this.validable, (double)this.permanentLimit, this.temporaryLimits.values(), (ValidationLevel)validationLevel, (ReportNode)reportNode);
    }

    private Optional<LoadingLimits.TemporaryLimit> getTemporaryLimitByName(String name) {
        return this.temporaryLimits.values().stream().filter(l -> l.getName().equals(name)).findFirst();
    }

    public double getTemporaryLimitValue(String name) {
        return this.getTemporaryLimitByName(name).map(LoadingLimits.TemporaryLimit::getValue).orElse(Double.NaN);
    }

    public int getTemporaryLimitAcceptableDuration(String name) {
        return this.getTemporaryLimitByName(name).map(LoadingLimits.TemporaryLimit::getAcceptableDuration).orElse(Integer.MAX_VALUE);
    }

    public double getLowestTemporaryLimitValue() {
        return this.temporaryLimits.values().stream().map(LoadingLimits.TemporaryLimit::getValue).min(Double::compareTo).orElse(Double.NaN);
    }

    public Collection<String> getTemporaryLimitNames() {
        return this.temporaryLimits.values().stream().map(LoadingLimits.TemporaryLimit::getName).toList();
    }

    public void removeTemporaryLimit(String name) {
        this.temporaryLimits.values().removeIf(l -> l.getName().equals(name));
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public class TemporaryLimitAdderImpl<B extends LoadingLimitsAdder<L, B>>
    implements LoadingLimitsAdder.TemporaryLimitAdder<B> {
        private String name;
        private double value = Double.NaN;
        private Integer acceptableDuration;
        private boolean fictitious = false;
        private boolean ensureNameUnicity = false;

        public LoadingLimitsAdder.TemporaryLimitAdder<B> setName(String name) {
            this.name = name;
            return this;
        }

        public LoadingLimitsAdder.TemporaryLimitAdder<B> setValue(double value) {
            this.value = value;
            return this;
        }

        public LoadingLimitsAdder.TemporaryLimitAdder<B> setAcceptableDuration(int acceptableDuration) {
            this.acceptableDuration = acceptableDuration;
            return this;
        }

        public LoadingLimitsAdder.TemporaryLimitAdder<B> setFictitious(boolean fictitious) {
            this.fictitious = fictitious;
            return this;
        }

        public LoadingLimitsAdder.TemporaryLimitAdder<B> ensureNameUnicity() {
            this.ensureNameUnicity = true;
            return this;
        }

        public B endTemporaryLimit() {
            if (Double.isNaN(this.value)) {
                throw new ValidationException(AbstractLoadingLimitsAdder.this.validable, "temporary limit value is not set");
            }
            if (this.value < 0.0) {
                throw new ValidationException(AbstractLoadingLimitsAdder.this.validable, "temporary limit value must be >= 0");
            }
            if (this.value == 0.0) {
                LOGGER.info("{}temporary limit value is set to 0", (Object)AbstractLoadingLimitsAdder.this.validable.getMessageHeader());
            }
            if (this.acceptableDuration == null) {
                throw new ValidationException(AbstractLoadingLimitsAdder.this.validable, "acceptable duration is not set");
            }
            if (this.acceptableDuration < 0) {
                throw new ValidationException(AbstractLoadingLimitsAdder.this.validable, "acceptable duration must be >= 0");
            }
            this.checkAndGetUniqueName();
            AbstractLoadingLimitsAdder.this.temporaryLimits.put(this.acceptableDuration, new AbstractLoadingLimits.TemporaryLimitImpl(this.name, this.value, this.acceptableDuration, this.fictitious));
            return (B)AbstractLoadingLimitsAdder.this;
        }

        private void checkAndGetUniqueName() {
            if (this.name == null) {
                throw new ValidationException(AbstractLoadingLimitsAdder.this.validable, "name is not set");
            }
            if (this.ensureNameUnicity) {
                Object uniqueName = this.name;
                for (int i = 0; i < Integer.MAX_VALUE && this.nameExists((String)uniqueName); ++i) {
                    uniqueName = this.name + "#" + i;
                }
                this.name = uniqueName;
            }
        }

        private boolean nameExists(String name) {
            return AbstractLoadingLimitsAdder.this.temporaryLimits.values().stream().anyMatch(t -> t.getName().equals(name));
        }
    }
}

