/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractInjectionAdder;
import com.powsybl.iidm.network.impl.BatteryImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import java.util.Objects;

public class BatteryAdderImpl
extends AbstractInjectionAdder<BatteryAdderImpl>
implements BatteryAdder {
    private double targetP = Double.NaN;
    private double targetQ = Double.NaN;
    private double minP = Double.NaN;
    private double maxP = Double.NaN;

    public BatteryAdderImpl(VoltageLevelExt voltageLevel) {
        this.voltageLevel = Objects.requireNonNull(voltageLevel);
    }

    @Override
    protected String getTypeDescription() {
        return "Battery";
    }

    public BatteryAdderImpl setTargetP(double targetP) {
        this.targetP = targetP;
        return this;
    }

    public BatteryAdderImpl setTargetQ(double targetQ) {
        this.targetQ = targetQ;
        return this;
    }

    public BatteryAdderImpl setMinP(double minP) {
        this.minP = minP;
        return this;
    }

    public BatteryAdderImpl setMaxP(double maxP) {
        this.maxP = maxP;
        return this;
    }

    public BatteryImpl add() {
        NetworkImpl network = this.getNetwork();
        String id = this.checkAndGetUniqueId();
        TerminalExt terminal = this.checkAndGetTerminal();
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkP0((Validable)this, (double)this.targetP, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkQ0((Validable)this, (double)this.targetQ, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        ValidationUtil.checkMinP((Validable)this, (double)this.minP);
        ValidationUtil.checkMaxP((Validable)this, (double)this.maxP);
        ValidationUtil.checkActivePowerLimits((Validable)this, (double)this.minP, (double)this.maxP);
        BatteryImpl battery = new BatteryImpl(this.getNetworkRef(), id, this.getName(), this.isFictitious(), this.targetP, this.targetQ, this.minP, this.maxP);
        battery.addTerminal(terminal);
        this.voltageLevel.attach(terminal, false);
        network.getIndex().checkAndAdd(battery);
        network.getListeners().notifyCreation(battery);
        return battery;
    }
}

