/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractInjectionAdder;
import com.powsybl.iidm.network.impl.DanglingLineImpl;
import com.powsybl.iidm.network.impl.GenerationAdderImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

class DanglingLineAdderImpl
extends AbstractInjectionAdder<DanglingLineAdderImpl>
implements DanglingLineAdder {
    private double p0 = Double.NaN;
    private double q0 = Double.NaN;
    private double r = Double.NaN;
    private double x = Double.NaN;
    private double g = 0.0;
    private double b = 0.0;
    private String pairingKey;
    private GenerationAdderImpl generationAdder;

    DanglingLineAdderImpl(VoltageLevelExt voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    void setGenerationAdder(GenerationAdderImpl adder) {
        this.generationAdder = adder;
    }

    @Override
    protected String getTypeDescription() {
        return "Dangling line";
    }

    public DanglingLineAdderImpl setP0(double p0) {
        this.p0 = p0;
        return this;
    }

    public DanglingLineAdderImpl setQ0(double q0) {
        this.q0 = q0;
        return this;
    }

    public DanglingLineAdderImpl setR(double r) {
        this.r = r;
        return this;
    }

    public DanglingLineAdderImpl setX(double x) {
        this.x = x;
        return this;
    }

    public DanglingLineAdderImpl setG(double g) {
        this.g = g;
        return this;
    }

    public DanglingLineAdderImpl setB(double b) {
        this.b = b;
        return this;
    }

    public DanglingLineAdder setPairingKey(String pairingKey) {
        this.pairingKey = pairingKey;
        return this;
    }

    public DanglingLineAdder.GenerationAdder newGeneration() {
        return new GenerationAdderImpl(this);
    }

    public DanglingLineImpl add() {
        NetworkImpl network = this.getNetwork();
        String id = this.checkAndGetUniqueId();
        TerminalExt terminal = this.checkAndGetTerminal();
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkP0((Validable)this, (double)this.p0, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkQ0((Validable)this, (double)this.q0, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        ValidationUtil.checkR((Validable)this, (double)this.r);
        ValidationUtil.checkX((Validable)this, (double)this.x);
        ValidationUtil.checkG((Validable)this, (double)this.g);
        ValidationUtil.checkB((Validable)this, (double)this.b);
        DanglingLineImpl.GenerationImpl generation = null;
        if (this.generationAdder != null) {
            generation = this.generationAdder.build();
        }
        DanglingLineImpl danglingLine = new DanglingLineImpl((Ref<NetworkImpl>)network.getRef(), id, this.getName(), this.isFictitious(), this.p0, this.q0, this.r, this.x, this.g, this.b, this.pairingKey, generation);
        danglingLine.addTerminal(terminal);
        this.voltageLevel.attach(terminal, false);
        network.getIndex().checkAndAdd(danglingLine);
        network.getListeners().notifyCreation(danglingLine);
        return danglingLine;
    }
}

