/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ExponentialLoadModel;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractLoadModelImpl;

public class ExponentialLoadModelImpl
extends AbstractLoadModelImpl
implements ExponentialLoadModel {
    private double np;
    private double nq;

    ExponentialLoadModelImpl(double np, double nq) {
        this.np = np;
        this.nq = nq;
    }

    static double checkExponent(Validable validable, double n) {
        if (Double.isNaN(n) || n < 0.0) {
            throw new ValidationException(validable, "Invalid load model exponential value: " + n);
        }
        return n;
    }

    public double getNp() {
        return this.np;
    }

    public ExponentialLoadModelImpl setNp(double np) {
        this.np = ExponentialLoadModelImpl.checkExponent(this.load, np);
        return this;
    }

    public double getNq() {
        return this.nq;
    }

    public ExponentialLoadModelImpl setNq(double nq) {
        this.nq = ExponentialLoadModelImpl.checkExponent(this.load, nq);
        return this;
    }
}

