/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractHvdcConverterStation;
import com.powsybl.iidm.network.impl.NetworkImpl;

class LccConverterStationImpl
extends AbstractHvdcConverterStation<LccConverterStation>
implements LccConverterStation {
    static final String TYPE_DESCRIPTION = "lccConverterStation";
    private float powerFactor;

    LccConverterStationImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious, float lossFactor, float powerFactor) {
        super(network, id, name, fictitious, lossFactor);
        this.powerFactor = powerFactor;
    }

    public HvdcConverterStation.HvdcType getHvdcType() {
        return HvdcConverterStation.HvdcType.LCC;
    }

    @Override
    protected String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public float getPowerFactor() {
        return this.powerFactor;
    }

    public LccConverterStation setPowerFactor(float powerFactor) {
        ValidationUtil.checkPowerFactor((Validable)this, (double)powerFactor);
        float oldValue = this.powerFactor;
        this.powerFactor = powerFactor;
        this.notifyUpdate("powerFactor", (Object)Float.valueOf(oldValue), (Object)Float.valueOf(powerFactor));
        return this;
    }
}

