/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.Iterables;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.CalculatedBus;
import com.powsybl.iidm.network.impl.ConfiguredBus;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

class MergedBus
extends AbstractIdentifiable<Bus>
implements CalculatedBus {
    private final Set<ConfiguredBus> buses;
    private boolean valid = true;

    MergedBus(String id, String name, boolean fictitious, Set<ConfiguredBus> buses) {
        super(id, name, fictitious);
        if (buses.isEmpty()) {
            throw new IllegalArgumentException("buses is empty");
        }
        this.buses = buses;
    }

    private void checkValidity() {
        if (!this.valid) {
            throw new PowsyblException("Bus has been invalidated");
        }
    }

    public boolean isInMainConnectedComponent() {
        Optional bus = this.buses.stream().findFirst();
        return bus.isPresent() && ((ConfiguredBus)bus.get()).isInMainConnectedComponent();
    }

    public boolean isInMainSynchronousComponent() {
        Optional bus = this.buses.stream().findFirst();
        return bus.isPresent() && ((ConfiguredBus)bus.get()).isInMainSynchronousComponent();
    }

    public int getConnectedTerminalCount() {
        this.checkValidity();
        return this.buses.stream().mapToInt(Bus::getConnectedTerminalCount).sum();
    }

    @Override
    public Iterable<TerminalExt> getConnectedTerminals() {
        this.checkValidity();
        return this.buses.stream().map(BusExt::getConnectedTerminals).reduce(Iterables::concat).orElse(Collections.emptyList());
    }

    @Override
    public Stream<TerminalExt> getConnectedTerminalStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(BusExt::getConnectedTerminalStream);
    }

    @Override
    public void invalidate() {
        this.valid = false;
        this.buses.clear();
    }

    @Override
    public NetworkImpl getNetwork() {
        return (NetworkImpl)this.getVoltageLevel().getNetwork();
    }

    public Network getParentNetwork() {
        return this.getVoltageLevel().getParentNetwork();
    }

    public VoltageLevel getVoltageLevel() {
        this.checkValidity();
        return this.buses.iterator().next().getVoltageLevel();
    }

    public double getV() {
        this.checkValidity();
        for (Bus bus : this.buses) {
            if (Double.isNaN(bus.getV())) continue;
            return bus.getV();
        }
        return Double.NaN;
    }

    public BusExt setV(double v) {
        this.checkValidity();
        for (ConfiguredBus bus : this.buses) {
            bus.setV(v);
        }
        return this;
    }

    public double getAngle() {
        this.checkValidity();
        for (Bus bus : this.buses) {
            if (Double.isNaN(bus.getAngle())) continue;
            return bus.getAngle();
        }
        return Double.NaN;
    }

    public BusExt setAngle(double angle) {
        this.checkValidity();
        for (ConfiguredBus bus : this.buses) {
            bus.setAngle(angle);
        }
        return this;
    }

    public double getP() {
        this.checkValidity();
        double p = 0.0;
        for (Bus bus : this.buses) {
            p += bus.getP();
        }
        return p;
    }

    public double getQ() {
        this.checkValidity();
        double q = 0.0;
        for (Bus bus : this.buses) {
            q += bus.getQ();
        }
        return q;
    }

    public double getFictitiousP0() {
        return this.buses.stream().map(Bus::getFictitiousP0).reduce(0.0, Double::sum);
    }

    public Bus setFictitiousP0(double p0) {
        this.buses.forEach(b -> b.setFictitiousP0(0.0));
        this.buses.iterator().next().setFictitiousP0(p0);
        return this;
    }

    public double getFictitiousQ0() {
        return this.buses.stream().map(Bus::getFictitiousQ0).reduce(0.0, Double::sum);
    }

    public Bus setFictitiousQ0(double q0) {
        this.buses.forEach(b -> b.setFictitiousQ0(0.0));
        this.buses.iterator().next().setFictitiousQ0(q0);
        return this;
    }

    @Override
    public void setConnectedComponentNumber(int connectedComponentNumber) {
        this.checkValidity();
        for (ConfiguredBus bus : this.buses) {
            bus.setConnectedComponentNumber(connectedComponentNumber);
        }
    }

    public Component getConnectedComponent() {
        this.checkValidity();
        for (Bus bus : this.buses) {
            Component cc = bus.getConnectedComponent();
            if (cc == null) continue;
            return cc;
        }
        throw new IllegalStateException("Should not happen");
    }

    @Override
    public void setSynchronousComponentNumber(int componentNumber) {
        this.checkValidity();
        for (ConfiguredBus bus : this.buses) {
            bus.setSynchronousComponentNumber(componentNumber);
        }
    }

    public Component getSynchronousComponent() {
        this.checkValidity();
        for (Bus bus : this.buses) {
            Component sc = bus.getSynchronousComponent();
            if (sc == null) continue;
            return sc;
        }
        throw new IllegalStateException("Should not happen");
    }

    public Iterable<Line> getLines() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getLines());
        }
        return Iterables.concat(iterables);
    }

    public Stream<Line> getLineStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getLineStream);
    }

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getTwoWindingsTransformers());
        }
        return Iterables.concat(iterables);
    }

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getTwoWindingsTransformerStream);
    }

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getThreeWindingsTransformers());
        }
        return Iterables.concat(iterables);
    }

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getThreeWindingsTransformerStream);
    }

    public Iterable<Generator> getGenerators() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getGenerators());
        }
        return Iterables.concat(iterables);
    }

    public Stream<Generator> getGeneratorStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getGeneratorStream);
    }

    public Iterable<Battery> getBatteries() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getBatteries());
        }
        return Iterables.concat(iterables);
    }

    public Stream<Battery> getBatteryStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getBatteryStream);
    }

    public Iterable<Load> getLoads() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getLoads());
        }
        return Iterables.concat(iterables);
    }

    public Stream<Load> getLoadStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getLoadStream);
    }

    public Iterable<ShuntCompensator> getShuntCompensators() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getShuntCompensators());
        }
        return Iterables.concat(iterables);
    }

    public Stream<ShuntCompensator> getShuntCompensatorStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getShuntCompensatorStream);
    }

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter danglingLineFilter) {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getDanglingLines(danglingLineFilter));
        }
        return Iterables.concat(iterables);
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter danglingLineFilter) {
        this.checkValidity();
        return this.buses.stream().flatMap(configuredBus -> configuredBus.getDanglingLineStream(danglingLineFilter));
    }

    public Iterable<StaticVarCompensator> getStaticVarCompensators() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getStaticVarCompensators());
        }
        return Iterables.concat(iterables);
    }

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getStaticVarCompensatorStream);
    }

    public Iterable<LccConverterStation> getLccConverterStations() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getLccConverterStations());
        }
        return Iterables.concat(iterables);
    }

    public Stream<LccConverterStation> getLccConverterStationStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getLccConverterStationStream);
    }

    public Iterable<VscConverterStation> getVscConverterStations() {
        this.checkValidity();
        ArrayList<Iterable> iterables = new ArrayList<Iterable>(this.buses.size());
        for (ConfiguredBus bus : this.buses) {
            iterables.add(bus.getVscConverterStations());
        }
        return Iterables.concat(iterables);
    }

    public Stream<VscConverterStation> getVscConverterStationStream() {
        this.checkValidity();
        return this.buses.stream().flatMap(Bus::getVscConverterStationStream);
    }

    public void visitConnectedEquipments(TopologyVisitor visitor) {
        this.checkValidity();
        for (ConfiguredBus bus : this.buses) {
            bus.visitConnectedEquipments(visitor);
        }
    }

    public void visitConnectedOrConnectableEquipments(TopologyVisitor visitor) {
        this.checkValidity();
        for (ConfiguredBus bus : this.buses) {
            bus.visitConnectedOrConnectableEquipments(visitor);
        }
    }

    @Override
    protected String getTypeDescription() {
        return "Bus";
    }
}

