/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.ref.RefChain;
import com.powsybl.commons.ref.RefObj;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.iidm.network.AbstractReportNodeContext;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Ground;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkListener;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.ReportNodeContext;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.SimpleReportNodeContext;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageAngleLimitAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.components.AbstractConnectedComponentsManager;
import com.powsybl.iidm.network.components.AbstractSynchronousComponentsManager;
import com.powsybl.iidm.network.impl.AbstractHvdcConverterStation;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.AreaAdderImpl;
import com.powsybl.iidm.network.impl.AreaImpl;
import com.powsybl.iidm.network.impl.BatteryImpl;
import com.powsybl.iidm.network.impl.BusBreakerVoltageLevel;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.BusbarSectionImpl;
import com.powsybl.iidm.network.impl.ConnectedComponentImpl;
import com.powsybl.iidm.network.impl.DanglingLineImpl;
import com.powsybl.iidm.network.impl.GeneratorImpl;
import com.powsybl.iidm.network.impl.GroundImpl;
import com.powsybl.iidm.network.impl.HvdcLineAdderImpl;
import com.powsybl.iidm.network.impl.HvdcLineImpl;
import com.powsybl.iidm.network.impl.LccConverterStationImpl;
import com.powsybl.iidm.network.impl.LineAdderImpl;
import com.powsybl.iidm.network.impl.LineImpl;
import com.powsybl.iidm.network.impl.LoadImpl;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkIndex;
import com.powsybl.iidm.network.impl.NetworkListenerList;
import com.powsybl.iidm.network.impl.NodeBreakerVoltageLevel;
import com.powsybl.iidm.network.impl.OverloadManagementSystemImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorImpl;
import com.powsybl.iidm.network.impl.StaticVarCompensatorImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.SubstationAdderImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.Substations;
import com.powsybl.iidm.network.impl.SwitchImpl;
import com.powsybl.iidm.network.impl.SynchronousComponentImpl;
import com.powsybl.iidm.network.impl.ThreeWindingsTransformerImpl;
import com.powsybl.iidm.network.impl.TieLineAdderImpl;
import com.powsybl.iidm.network.impl.TieLineImpl;
import com.powsybl.iidm.network.impl.TwoWindingsTransformerImpl;
import com.powsybl.iidm.network.impl.Variant;
import com.powsybl.iidm.network.impl.VariantArray;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.VariantManagerImpl;
import com.powsybl.iidm.network.impl.VoltageAngleLimitAdderImpl;
import com.powsybl.iidm.network.impl.VoltageLevelAdderImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.VscConverterStationImpl;
import com.powsybl.iidm.network.util.Identifiables;
import com.powsybl.iidm.network.util.Networks;
import com.powsybl.iidm.network.util.TieLineUtil;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkImpl
extends AbstractNetwork
implements VariantManagerHolder,
MultiVariantObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkImpl.class);
    private final RefChain<NetworkImpl> ref = new RefChain((Ref)new RefObj((Object)this));
    private RefChain<SubnetworkImpl> subnetworkRef = new RefChain((Ref)new RefObj(null));
    private ValidationLevel validationLevel = ValidationLevel.STEADY_STATE_HYPOTHESIS;
    private ValidationLevel minValidationLevel = ValidationLevel.STEADY_STATE_HYPOTHESIS;
    private final NetworkIndex index = new NetworkIndex();
    private final Map<String, VoltageAngleLimit> voltageAngleLimitsIndex = new LinkedHashMap<String, VoltageAngleLimit>();
    private final VariantManagerImpl variantManager;
    private AbstractReportNodeContext reportNodeContext;
    private final NetworkListenerList listeners = new NetworkListenerList();
    private final Map<String, SubnetworkImpl> subnetworks = new LinkedHashMap<String, SubnetworkImpl>();
    private final BusBreakerViewImpl busBreakerView = new BusBreakerViewImpl();
    private final BusViewImpl busView = new BusViewImpl();
    private final VariantArray<VariantImpl> variants;

    public Collection<Network> getSubnetworks() {
        return this.subnetworks.values().stream().map(Network.class::cast).toList();
    }

    public Network getSubnetwork(String id) {
        return this.subnetworks.get(id);
    }

    void removeFromSubnetworks(String subnetworkId) {
        this.subnetworks.remove(subnetworkId);
    }

    NetworkImpl(String id, String name, String sourceFormat) {
        super(id, name, sourceFormat);
        this.ref.setRef((Ref)new RefObj((Object)this));
        this.reportNodeContext = new SimpleReportNodeContext();
        this.variantManager = new VariantManagerImpl(this);
        this.variants = new VariantArray<VariantImpl>((Ref<VariantManagerHolder>)this.ref, () -> new VariantImpl());
        this.index.checkAndAdd(this);
    }

    static Network merge(String id, String name, Network ... networks) {
        if (networks == null || networks.length < 2) {
            throw new IllegalArgumentException("At least 2 networks are expected");
        }
        NetworkImpl mergedNetwork = new NetworkImpl(id, name, networks[0].getSourceFormat());
        NetworkImpl.setValidationLevels(mergedNetwork, networks);
        NetworkImpl.setCommonCaseDate(mergedNetwork, networks);
        for (Network other : networks) {
            mergedNetwork.merge(other);
        }
        return mergedNetwork;
    }

    private static void setValidationLevels(NetworkImpl mergedNetwork, Network[] networks) {
        ValidationLevel minLevel = mergedNetwork.getMinValidationLevel();
        ValidationLevel validationLevel = mergedNetwork.getValidationLevel();
        for (Network n : networks) {
            if (!(n instanceof NetworkImpl)) continue;
            NetworkImpl networkImpl = (NetworkImpl)n;
            minLevel = ValidationLevel.min((ValidationLevel)minLevel, (ValidationLevel)networkImpl.getMinValidationLevel());
            validationLevel = ValidationLevel.min((ValidationLevel)validationLevel, (ValidationLevel)networkImpl.getValidationLevel());
        }
        mergedNetwork.setMinimumAcceptableValidationLevel(minLevel);
        mergedNetwork.setValidationLevelIfGreaterThan(validationLevel);
    }

    private static void setCommonCaseDate(NetworkImpl mergedNetwork, Network[] networks) {
        ZonedDateTime caseDate = networks[0].getCaseDate();
        for (Network n : networks) {
            if (Objects.equals(caseDate, n.getCaseDate())) continue;
            return;
        }
        mergedNetwork.setCaseDate(caseDate);
    }

    RefChain<NetworkImpl> getRef() {
        return this.ref;
    }

    @Override
    public RefChain<NetworkImpl> getRootNetworkRef() {
        return this.getRef();
    }

    public NetworkListenerList getListeners() {
        return this.listeners;
    }

    public NetworkIndex getIndex() {
        return this.index;
    }

    public Map<String, VoltageAngleLimit> getVoltageAngleLimitsIndex() {
        return this.voltageAngleLimitsIndex;
    }

    public VoltageAngleLimit getVoltageAngleLimit(String id) {
        return this.voltageAngleLimitsIndex.get(id);
    }

    public Stream<VoltageAngleLimit> getVoltageAngleLimitsStream() {
        return this.voltageAngleLimitsIndex.values().stream();
    }

    public Iterable<VoltageAngleLimit> getVoltageAngleLimits() {
        return this.voltageAngleLimitsIndex.values();
    }

    @Override
    public NetworkImpl getNetwork() {
        return this;
    }

    public Network getParentNetwork() {
        return this;
    }

    @Override
    public VariantManagerImpl getVariantManager() {
        return this.variantManager;
    }

    public void allowReportNodeContextMultiThreadAccess(boolean allow) {
        this.reportNodeContext = Networks.allowReportNodeContextMultiThreadAccess((AbstractReportNodeContext)this.reportNodeContext, (boolean)allow);
    }

    public ReportNodeContext getReportNodeContext() {
        return this.reportNodeContext;
    }

    @Override
    public int getVariantIndex() {
        return this.variantManager.getVariantContext().getVariantIndex();
    }

    public Set<Country> getCountries() {
        return this.getSubstationStream().map(Substation::getCountry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(Country.class)));
    }

    public int getCountryCount() {
        return this.getCountries().size();
    }

    public Iterable<String> getAreaTypes() {
        return this.getAreaTypeStream().toList();
    }

    public Stream<String> getAreaTypeStream() {
        return this.getAreaStream().map(Area::getAreaType).distinct();
    }

    public int getAreaTypeCount() {
        return (int)this.getAreaTypeStream().count();
    }

    public AreaAdder newArea() {
        return new AreaAdderImpl((Ref<NetworkImpl>)this.ref, this.subnetworkRef);
    }

    public Iterable<Area> getAreas() {
        return Collections.unmodifiableCollection(this.index.getAll(AreaImpl.class));
    }

    public Stream<Area> getAreaStream() {
        return this.index.getAll(AreaImpl.class).stream().map(Function.identity());
    }

    public Area getArea(String id) {
        return this.index.get(id, AreaImpl.class);
    }

    public int getAreaCount() {
        return this.index.getAll(AreaImpl.class).size();
    }

    public SubstationAdder newSubstation() {
        return new SubstationAdderImpl((Ref<NetworkImpl>)this.ref, (Ref<SubnetworkImpl>)this.subnetworkRef);
    }

    public Iterable<Substation> getSubstations() {
        return Collections.unmodifiableCollection(this.index.getAll(SubstationImpl.class));
    }

    public Stream<Substation> getSubstationStream() {
        return this.index.getAll(SubstationImpl.class).stream().map(Function.identity());
    }

    public int getSubstationCount() {
        return this.index.getAll(SubstationImpl.class).size();
    }

    public Iterable<Substation> getSubstations(Country country, String tsoId, String ... geographicalTags) {
        return this.getSubstations((String)Optional.ofNullable(country).map(Country::getName).orElse(null), tsoId, geographicalTags);
    }

    public Iterable<Substation> getSubstations(String country, String tsoId, String ... geographicalTags) {
        return Substations.filter(this.getSubstations(), country, tsoId, geographicalTags);
    }

    public SubstationImpl getSubstation(String id) {
        return this.index.get(id, SubstationImpl.class);
    }

    public VoltageLevelAdder newVoltageLevel() {
        return new VoltageLevelAdderImpl((Ref<NetworkImpl>)this.ref, (Ref<SubnetworkImpl>)this.subnetworkRef);
    }

    public Iterable<VoltageLevel> getVoltageLevels() {
        return Iterables.concat(this.index.getAll(BusBreakerVoltageLevel.class), this.index.getAll(NodeBreakerVoltageLevel.class));
    }

    public Stream<VoltageLevel> getVoltageLevelStream() {
        return Stream.concat(this.index.getAll(BusBreakerVoltageLevel.class).stream(), this.index.getAll(NodeBreakerVoltageLevel.class).stream());
    }

    public int getVoltageLevelCount() {
        return this.index.getAll(BusBreakerVoltageLevel.class).size() + this.index.getAll(NodeBreakerVoltageLevel.class).size();
    }

    public VoltageLevelExt getVoltageLevel(String id) {
        return this.index.get(id, VoltageLevelExt.class);
    }

    public LineAdderImpl newLine() {
        return this.newLine(null);
    }

    LineAdderImpl newLine(String subnetwork) {
        return new LineAdderImpl(this, subnetwork);
    }

    public Iterable<Line> getLines() {
        return Collections.unmodifiableCollection(this.index.getAll(LineImpl.class));
    }

    public Iterable<TieLine> getTieLines() {
        return Collections.unmodifiableCollection(this.index.getAll(TieLineImpl.class));
    }

    public Branch getBranch(String branchId) {
        Objects.requireNonNull(branchId);
        Line branch = this.getLine(branchId);
        if (branch == null && (branch = this.getTwoWindingsTransformer(branchId)) == null) {
            branch = this.getTieLine(branchId);
        }
        return branch;
    }

    public Iterable<Branch> getBranches() {
        return Iterables.concat(this.getLines(), this.getTwoWindingsTransformers(), this.getTieLines());
    }

    public Stream<Branch> getBranchStream() {
        return Stream.of(this.getLineStream(), this.getTwoWindingsTransformerStream(), this.getTieLineStream()).flatMap(Function.identity());
    }

    public int getBranchCount() {
        return this.getLineCount() + this.getTwoWindingsTransformerCount() + this.getTieLineCount();
    }

    public Stream<Line> getLineStream() {
        return this.index.getAll(LineImpl.class).stream().map(Function.identity());
    }

    public Stream<TieLine> getTieLineStream() {
        return this.index.getAll(TieLineImpl.class).stream().map(Function.identity());
    }

    public int getLineCount() {
        return this.index.getAll(LineImpl.class).size();
    }

    public int getTieLineCount() {
        return this.index.getAll(TieLineImpl.class).size();
    }

    public Line getLine(String id) {
        return this.index.get(id, LineImpl.class);
    }

    public TieLine getTieLine(String id) {
        return this.index.get(id, TieLineImpl.class);
    }

    public TieLineAdderImpl newTieLine() {
        return this.newTieLine(null);
    }

    TieLineAdderImpl newTieLine(String subnetwork) {
        return new TieLineAdderImpl(this, subnetwork);
    }

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers() {
        return Collections.unmodifiableCollection(this.index.getAll(TwoWindingsTransformerImpl.class));
    }

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream() {
        return this.index.getAll(TwoWindingsTransformerImpl.class).stream().map(Function.identity());
    }

    public int getTwoWindingsTransformerCount() {
        return this.index.getAll(TwoWindingsTransformerImpl.class).size();
    }

    public TwoWindingsTransformer getTwoWindingsTransformer(String id) {
        return this.index.get(id, TwoWindingsTransformerImpl.class);
    }

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers() {
        return Collections.unmodifiableCollection(this.index.getAll(ThreeWindingsTransformerImpl.class));
    }

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream() {
        return this.index.getAll(ThreeWindingsTransformerImpl.class).stream().map(Function.identity());
    }

    public int getThreeWindingsTransformerCount() {
        return this.index.getAll(ThreeWindingsTransformerImpl.class).size();
    }

    public ThreeWindingsTransformer getThreeWindingsTransformer(String id) {
        return this.index.get(id, ThreeWindingsTransformerImpl.class);
    }

    public Iterable<OverloadManagementSystem> getOverloadManagementSystems() {
        return Collections.unmodifiableCollection(this.index.getAll(OverloadManagementSystemImpl.class));
    }

    public Stream<OverloadManagementSystem> getOverloadManagementSystemStream() {
        return this.index.getAll(OverloadManagementSystemImpl.class).stream().map(Function.identity());
    }

    public int getOverloadManagementSystemCount() {
        return this.index.getAll(OverloadManagementSystemImpl.class).size();
    }

    public OverloadManagementSystem getOverloadManagementSystem(String id) {
        return this.index.get(id, OverloadManagementSystemImpl.class);
    }

    public Iterable<Generator> getGenerators() {
        return Collections.unmodifiableCollection(this.index.getAll(GeneratorImpl.class));
    }

    public Stream<Generator> getGeneratorStream() {
        return this.index.getAll(GeneratorImpl.class).stream().map(Function.identity());
    }

    public int getGeneratorCount() {
        return this.index.getAll(GeneratorImpl.class).size();
    }

    public GeneratorImpl getGenerator(String id) {
        return this.index.get(id, GeneratorImpl.class);
    }

    public Iterable<Battery> getBatteries() {
        return Collections.unmodifiableCollection(this.index.getAll(BatteryImpl.class));
    }

    public Stream<Battery> getBatteryStream() {
        return this.index.getAll(BatteryImpl.class).stream().map(Function.identity());
    }

    public int getBatteryCount() {
        return this.index.getAll(BatteryImpl.class).size();
    }

    public BatteryImpl getBattery(String id) {
        return this.index.get(id, BatteryImpl.class);
    }

    public Iterable<Load> getLoads() {
        return Collections.unmodifiableCollection(this.index.getAll(LoadImpl.class));
    }

    public Stream<Load> getLoadStream() {
        return this.index.getAll(LoadImpl.class).stream().map(Function.identity());
    }

    public int getLoadCount() {
        return this.index.getAll(LoadImpl.class).size();
    }

    public LoadImpl getLoad(String id) {
        return this.index.get(id, LoadImpl.class);
    }

    public Iterable<ShuntCompensator> getShuntCompensators() {
        return Collections.unmodifiableCollection(this.index.getAll(ShuntCompensatorImpl.class));
    }

    public Stream<ShuntCompensator> getShuntCompensatorStream() {
        return this.index.getAll(ShuntCompensatorImpl.class).stream().map(Function.identity());
    }

    public int getShuntCompensatorCount() {
        return this.index.getAll(ShuntCompensatorImpl.class).size();
    }

    public ShuntCompensatorImpl getShuntCompensator(String id) {
        return this.index.get(id, ShuntCompensatorImpl.class);
    }

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter danglingLineFilter) {
        return this.getDanglingLineStream(danglingLineFilter).collect(Collectors.toList());
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter danglingLineFilter) {
        return this.index.getAll(DanglingLineImpl.class).stream().filter(danglingLineFilter.getPredicate()).map(Function.identity());
    }

    public int getDanglingLineCount() {
        return this.index.getAll(DanglingLineImpl.class).size();
    }

    public DanglingLineImpl getDanglingLine(String id) {
        return this.index.get(id, DanglingLineImpl.class);
    }

    public Iterable<StaticVarCompensator> getStaticVarCompensators() {
        return Collections.unmodifiableCollection(this.index.getAll(StaticVarCompensatorImpl.class));
    }

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream() {
        return this.index.getAll(StaticVarCompensatorImpl.class).stream().map(Function.identity());
    }

    public int getStaticVarCompensatorCount() {
        return this.index.getAll(StaticVarCompensatorImpl.class).size();
    }

    public StaticVarCompensatorImpl getStaticVarCompensator(String id) {
        return this.index.get(id, StaticVarCompensatorImpl.class);
    }

    public Switch getSwitch(String id) {
        return this.index.get(id, SwitchImpl.class);
    }

    public Iterable<Switch> getSwitches() {
        return Collections.unmodifiableCollection(this.index.getAll(SwitchImpl.class));
    }

    public Stream<Switch> getSwitchStream() {
        return this.index.getAll(SwitchImpl.class).stream().map(Function.identity());
    }

    public int getSwitchCount() {
        return this.index.getAll(SwitchImpl.class).size();
    }

    public BusbarSection getBusbarSection(String id) {
        return this.index.get(id, BusbarSectionImpl.class);
    }

    public Iterable<BusbarSection> getBusbarSections() {
        return Collections.unmodifiableCollection(this.index.getAll(BusbarSectionImpl.class));
    }

    public Stream<BusbarSection> getBusbarSectionStream() {
        return this.index.getAll(BusbarSectionImpl.class).stream().map(Function.identity());
    }

    public int getBusbarSectionCount() {
        return this.index.getAll(BusbarSectionImpl.class).size();
    }

    public AbstractHvdcConverterStation<?> getHvdcConverterStation(String id) {
        AbstractHvdcConverterStation converterStation = this.getLccConverterStation(id);
        if (converterStation == null) {
            converterStation = this.getVscConverterStation(id);
        }
        return converterStation;
    }

    public int getHvdcConverterStationCount() {
        return this.getLccConverterStationCount() + this.getVscConverterStationCount();
    }

    public Iterable<HvdcConverterStation<?>> getHvdcConverterStations() {
        return Iterables.concat(this.getLccConverterStations(), this.getVscConverterStations());
    }

    public Stream<HvdcConverterStation<?>> getHvdcConverterStationStream() {
        return Stream.concat(this.getLccConverterStationStream(), this.getVscConverterStationStream());
    }

    public Iterable<LccConverterStation> getLccConverterStations() {
        return Collections.unmodifiableCollection(this.index.getAll(LccConverterStationImpl.class));
    }

    public Stream<LccConverterStation> getLccConverterStationStream() {
        return this.index.getAll(LccConverterStationImpl.class).stream().map(Function.identity());
    }

    public int getLccConverterStationCount() {
        return this.index.getAll(LccConverterStationImpl.class).size();
    }

    public LccConverterStationImpl getLccConverterStation(String id) {
        return this.index.get(id, LccConverterStationImpl.class);
    }

    public Iterable<VscConverterStation> getVscConverterStations() {
        return Collections.unmodifiableCollection(this.index.getAll(VscConverterStationImpl.class));
    }

    public Stream<VscConverterStation> getVscConverterStationStream() {
        return this.index.getAll(VscConverterStationImpl.class).stream().map(Function.identity());
    }

    public int getVscConverterStationCount() {
        return this.index.getAll(VscConverterStationImpl.class).size();
    }

    public VscConverterStationImpl getVscConverterStation(String id) {
        return this.index.get(id, VscConverterStationImpl.class);
    }

    public HvdcLine getHvdcLine(String id) {
        return this.index.get(id, HvdcLineImpl.class);
    }

    public HvdcLine getHvdcLine(HvdcConverterStation converterStation) {
        return this.getHvdcLineStream().filter(l -> l.getConverterStation1() == converterStation || l.getConverterStation2() == converterStation).findFirst().orElse(null);
    }

    public int getHvdcLineCount() {
        return this.index.getAll(HvdcLineImpl.class).size();
    }

    public Iterable<HvdcLine> getHvdcLines() {
        return Collections.unmodifiableCollection(this.index.getAll(HvdcLineImpl.class));
    }

    public Stream<HvdcLine> getHvdcLineStream() {
        return this.index.getAll(HvdcLineImpl.class).stream().map(Function.identity());
    }

    public HvdcLineAdder newHvdcLine() {
        return this.newHvdcLine(null);
    }

    public Ground getGround(String id) {
        return this.index.get(id, GroundImpl.class);
    }

    public Iterable<Ground> getGrounds() {
        return Collections.unmodifiableCollection(this.index.getAll(GroundImpl.class));
    }

    public Stream<Ground> getGroundStream() {
        return this.index.getAll(GroundImpl.class).stream().map(Function.identity());
    }

    public int getGroundCount() {
        return this.index.getAll(GroundImpl.class).size();
    }

    HvdcLineAdder newHvdcLine(String subnetwork) {
        return new HvdcLineAdderImpl(this, subnetwork);
    }

    public Identifiable<?> getIdentifiable(String id) {
        return this.index.get(id, Identifiable.class);
    }

    public Collection<Identifiable<?>> getIdentifiables() {
        return this.index.getAll();
    }

    public <C extends Connectable> Iterable<C> getConnectables(Class<C> clazz) {
        return this.getConnectableStream(clazz).collect(Collectors.toList());
    }

    public <C extends Connectable> Stream<C> getConnectableStream(Class<C> clazz) {
        return this.index.getAll().stream().filter(clazz::isInstance).map(clazz::cast);
    }

    public <C extends Connectable> int getConnectableCount(Class<C> clazz) {
        return Ints.checkedCast((long)this.getConnectableStream(clazz).count());
    }

    public Iterable<Connectable> getConnectables() {
        return this.getConnectables(Connectable.class);
    }

    public Stream<Connectable> getConnectableStream() {
        return this.getConnectableStream(Connectable.class);
    }

    public Connectable<?> getConnectable(String id) {
        return this.index.get(id, Connectable.class);
    }

    public int getConnectableCount() {
        return Ints.checkedCast((long)this.getConnectableStream().count());
    }

    public VoltageAngleLimitAdder newVoltageAngleLimit() {
        return this.newVoltageAngleLimit(null);
    }

    VoltageAngleLimitAdder newVoltageAngleLimit(String subnetwork) {
        return new VoltageAngleLimitAdderImpl(this, subnetwork);
    }

    public BusBreakerViewImpl getBusBreakerView() {
        return this.busBreakerView;
    }

    public BusViewImpl getBusView() {
        return this.busView;
    }

    ConnectedComponentsManager getConnectedComponentsManager() {
        return this.variants.get().connectedComponentsManager;
    }

    SynchronousComponentsManager getSynchronousComponentsManager() {
        return this.variants.get().synchronousComponentsManager;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.variants.push(number, () -> this.variants.copy(sourceIndex));
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.variants.pop(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.variants.delete(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        this.variants.allocate(indexes, () -> this.variants.copy(sourceIndex));
    }

    private static void checkIndependentNetwork(Network network) {
        if (network instanceof SubnetworkImpl) {
            throw new IllegalArgumentException("The network " + network.getId() + " is already a subnetwork");
        }
        if (!network.getSubnetworks().isEmpty()) {
            throw new IllegalArgumentException("The network " + network.getId() + " already contains subnetworks: not supported");
        }
    }

    private void merge(Network other) {
        NetworkImpl.checkIndependentNetwork(other);
        NetworkImpl otherNetwork = (NetworkImpl)other;
        if (this.variantManager.getVariantArraySize() != 1 || otherNetwork.variantManager.getVariantArraySize() != 1) {
            throw new PowsyblException("Merging of multi-variants network is not supported");
        }
        long start = System.currentTimeMillis();
        this.checkMergeability(otherNetwork);
        otherNetwork.getAreaStream().forEach(a -> {
            AreaImpl area = (AreaImpl)a;
            area.moveListener(otherNetwork, this);
        });
        ArrayList<DanglingLinePair> lines = new ArrayList<DanglingLinePair>();
        HashMap<String, List> dl1byPairingKey = new HashMap<String, List>();
        for (DanglingLine dl1 : this.getDanglingLines(DanglingLineFilter.ALL)) {
            if (dl1.getPairingKey() == null) continue;
            dl1byPairingKey.computeIfAbsent(dl1.getPairingKey(), k -> new ArrayList()).add(dl1);
        }
        for (DanglingLine dl2 : TieLineUtil.findCandidateDanglingLines((Network)other, dl1byPairingKey::containsKey)) {
            TieLineUtil.findAndAssociateDanglingLines((DanglingLine)dl2, dl1byPairingKey::get, (dll1, dll2) -> this.pairDanglingLines((List<DanglingLinePair>)lines, (DanglingLine)dll1, (DanglingLine)dll2, (Map<String, List<DanglingLine>>)dl1byPairingKey));
        }
        NetworkImpl.createSubnetwork(this, otherNetwork);
        otherNetwork.index.remove(otherNetwork);
        this.index.merge(otherNetwork.index);
        this.replaceDanglingLineByTieLine(lines);
        other.getVoltageAngleLimits().forEach(l -> this.getVoltageAngleLimitsIndex().put(l.getId(), (VoltageAngleLimit)l));
        if (!this.sourceFormat.equals(otherNetwork.sourceFormat)) {
            this.sourceFormat = "hybrid";
        }
        LOGGER.info("Merging of {} done in {} ms", (Object)this.id, (Object)(System.currentTimeMillis() - start));
    }

    private void checkMergeability(NetworkImpl otherNetwork) {
        Multimap<Class<? extends Identifiable>, String> intersection = this.index.intersection(otherNetwork.index);
        for (Map.Entry entry : intersection.asMap().entrySet()) {
            Class clazz = (Class)entry.getKey();
            Collection objs = (Collection)entry.getValue();
            if (objs.isEmpty()) continue;
            throw new PowsyblException("The following object(s) of type " + clazz.getSimpleName() + " exist(s) in both networks: " + objs);
        }
        Set intersectionVoltageAngleLimits = this.getVoltageAngleLimitsIndex().keySet().stream().filter(otherNetwork.getVoltageAngleLimitsIndex()::containsKey).collect(Collectors.toSet());
        if (!intersectionVoltageAngleLimits.isEmpty()) {
            throw new PowsyblException("The following voltage angle limit(s) exist(s) in both networks: " + intersectionVoltageAngleLimits);
        }
    }

    private static void createSubnetwork(NetworkImpl parent, NetworkImpl original) {
        original.ref.setRef((Ref)new RefObj((Object)parent));
        String idSubNetwork = parent != original ? original.getId() : Identifiables.getUniqueId((String)original.getId(), parent.getIndex()::contains);
        SubnetworkImpl sn = new SubnetworkImpl(original.ref, original.subnetworkRef, idSubNetwork, original.name, original.sourceFormat, original.getCaseDate());
        NetworkImpl.transferExtensions(original, sn);
        NetworkImpl.transferProperties(original, sn);
        parent.subnetworks.put(idSubNetwork, sn);
        parent.index.checkAndAdd(sn);
    }

    private void pairDanglingLines(List<DanglingLinePair> danglingLinePairs, DanglingLine dl1, DanglingLine dl2, Map<String, List<DanglingLine>> dl1byPairingKey) {
        if (dl1 != null) {
            if (dl1.getPairingKey() != null) {
                dl1byPairingKey.get(dl1.getPairingKey()).remove(dl1);
            }
            DanglingLinePair l = new DanglingLinePair();
            l.id = TieLineUtil.buildMergedId((String)dl1.getId(), (String)dl2.getId());
            l.name = TieLineUtil.buildMergedName((String)dl1.getId(), (String)dl2.getId(), (String)dl1.getOptionalName().orElse(null), (String)dl2.getOptionalName().orElse(null));
            l.dl1Id = dl1.getId();
            l.dl2Id = dl2.getId();
            l.aliases = new HashMap<String, String>();
            danglingLinePairs.add(l);
            if (dl1.getId().equals(dl2.getId())) {
                ((DanglingLineImpl)dl1).replaceId(l.dl1Id + "_1");
                ((DanglingLineImpl)dl2).replaceId(l.dl2Id + "_2");
                l.dl1Id = dl1.getId();
                l.dl2Id = dl2.getId();
            } else if (l.dl1Id.compareTo(l.dl2Id) > 0) {
                String tmp = l.dl1Id;
                l.dl1Id = l.dl2Id;
                l.dl2Id = tmp;
            }
        }
    }

    private void replaceDanglingLineByTieLine(List<DanglingLinePair> lines) {
        for (DanglingLinePair danglingLinePair : lines) {
            LOGGER.debug("Creating tie line '{}' between dangling line couple '{}' and '{}", new Object[]{danglingLinePair.id, danglingLinePair.dl1Id, danglingLinePair.dl2Id});
            TieLineImpl l = ((TieLineAdderImpl)((TieLineAdderImpl)((TieLineAdderImpl)this.newTieLine().setId(danglingLinePair.id)).setEnsureIdUnicity(true)).setName(danglingLinePair.name)).setDanglingLine1(danglingLinePair.dl1Id).setDanglingLine2(danglingLinePair.dl2Id).add();
            danglingLinePair.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> l.setProperty(key.toString(), val.toString())));
            danglingLinePair.aliases.forEach((alias, type) -> {
                if (type.isEmpty()) {
                    l.addAlias((String)alias);
                } else {
                    l.addAlias((String)alias, (String)type);
                }
            });
        }
    }

    public Network createSubnetwork(String subnetworkId, String name, String sourceFormat) {
        if (this.subnetworks.containsKey(subnetworkId)) {
            throw new IllegalArgumentException("The network already contains another subnetwork of id " + subnetworkId);
        }
        SubnetworkImpl subnetwork = new SubnetworkImpl((RefChain<NetworkImpl>)new RefChain((Ref)new RefObj((Object)this)), subnetworkId, name, sourceFormat);
        this.subnetworks.put(subnetworkId, subnetwork);
        this.index.checkAndAdd(subnetwork);
        return subnetwork;
    }

    public Network detach() {
        throw new IllegalStateException("This network is already detached.");
    }

    public boolean isDetachable() {
        return false;
    }

    public Set<Identifiable<?>> getBoundaryElements() {
        return this.getDanglingLineStream(DanglingLineFilter.UNPAIRED).collect(Collectors.toSet());
    }

    public boolean isBoundaryElement(Identifiable<?> identifiable) {
        return identifiable.getType() == IdentifiableType.DANGLING_LINE && !((DanglingLine)identifiable).isPaired();
    }

    public void addListener(NetworkListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(NetworkListener listener) {
        this.listeners.remove(listener);
    }

    public ValidationLevel runValidationChecks() {
        return this.runValidationChecks(true);
    }

    public ValidationLevel runValidationChecks(boolean throwsException) {
        return this.runValidationChecks(throwsException, ReportNode.NO_OP);
    }

    public ValidationLevel runValidationChecks(boolean throwsException, ReportNode reportNode) {
        ReportNode readReportNode = ((ReportNodeAdder)((ReportNodeAdder)Objects.requireNonNull(reportNode).newReportNode().withMessageTemplate("IIDMValidation", "Running validation checks on IIDM network ${networkId}")).withUntypedValue("networkId", this.id)).add();
        this.validationLevel = ValidationUtil.validate(Collections.unmodifiableCollection(this.index.getAll()), (boolean)true, (boolean)throwsException, (ValidationLevel)(this.validationLevel != null ? this.validationLevel : this.minValidationLevel), (ReportNode)readReportNode);
        return this.validationLevel;
    }

    public ValidationLevel getValidationLevel() {
        if (this.validationLevel == null) {
            this.validationLevel = ValidationUtil.validate(Collections.unmodifiableCollection(this.index.getAll()), (boolean)false, (boolean)false, (ValidationLevel)this.minValidationLevel, (ReportNode)ReportNode.NO_OP);
        }
        return this.validationLevel;
    }

    public Network setMinimumAcceptableValidationLevel(ValidationLevel validationLevel) {
        Objects.requireNonNull(validationLevel);
        if (this.validationLevel == null) {
            this.validationLevel = ValidationUtil.validate(Collections.unmodifiableCollection(this.index.getAll()), (boolean)false, (boolean)false, (ValidationLevel)this.validationLevel, (ReportNode)ReportNode.NO_OP);
        }
        if (this.validationLevel.compareTo((Enum)validationLevel) < 0) {
            throw new ValidationException((Validable)this, "Network should be corrected in order to correspond to validation level " + validationLevel);
        }
        this.minValidationLevel = validationLevel;
        return this;
    }

    ValidationLevel getMinValidationLevel() {
        return this.minValidationLevel;
    }

    void setValidationLevelIfGreaterThan(ValidationLevel validationLevel) {
        if (this.validationLevel != null) {
            this.validationLevel = ValidationLevel.min((ValidationLevel)this.validationLevel, (ValidationLevel)validationLevel);
        }
    }

    void invalidateValidationLevel() {
        if (this.minValidationLevel.compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) < 0) {
            this.validationLevel = null;
        }
    }

    class BusBreakerViewImpl
    extends AbstractNetwork.AbstractBusBreakerViewImpl {
        BusBreakerViewImpl() {
        }

        public Bus getBus(String id) {
            Bus bus = NetworkImpl.this.index.get(id, Bus.class);
            if (bus != null) {
                return bus;
            }
            return NetworkImpl.this.variants.get().busBreakerViewCache.getBus(id);
        }

        void invalidateCache() {
            NetworkImpl.this.variants.get().busBreakerViewCache.invalidate();
        }
    }

    class BusViewImpl
    extends AbstractNetwork.AbstractBusViewImpl {
        BusViewImpl() {
        }

        public Collection<Component> getConnectedComponents() {
            return Collections.unmodifiableList(NetworkImpl.this.variants.get().connectedComponentsManager.getConnectedComponents());
        }

        public Collection<Component> getSynchronousComponents() {
            return Collections.unmodifiableList(NetworkImpl.this.variants.get().synchronousComponentsManager.getConnectedComponents());
        }

        public Bus getBus(String id) {
            return NetworkImpl.this.variants.get().busViewCache.getBus(id);
        }

        void invalidateCache() {
            NetworkImpl.this.variants.get().busViewCache.invalidate();
        }
    }

    private class VariantImpl
    implements Variant {
        private final ConnectedComponentsManager connectedComponentsManager;
        private final SynchronousComponentsManager synchronousComponentsManager;
        private final BusCache busViewCache;
        private final BusCache busBreakerViewCache;

        private VariantImpl() {
            this.connectedComponentsManager = new ConnectedComponentsManager(NetworkImpl.this);
            this.synchronousComponentsManager = new SynchronousComponentsManager(NetworkImpl.this);
            this.busViewCache = new BusCache(() -> NetworkImpl.this.getVoltageLevelStream().flatMap(vl -> vl.getBusView().getBusStream()));
            this.busBreakerViewCache = new BusCache(() -> NetworkImpl.this.getVoltageLevelStream().filter(vl -> vl.getTopologyKind() != TopologyKind.BUS_BREAKER).flatMap(vl -> vl.getBusBreakerView().getBusStream()));
        }

        public VariantImpl copy() {
            return new VariantImpl();
        }
    }

    static final class ConnectedComponentsManager
    extends AbstractConnectedComponentsManager<ConnectedComponentImpl> {
        private final NetworkImpl network;

        private ConnectedComponentsManager(NetworkImpl network) {
            this.network = Objects.requireNonNull(network);
        }

        protected Network getNetwork() {
            return this.network;
        }

        protected void setComponentNumber(Bus bus, int num) {
            Objects.requireNonNull(bus);
            ((BusExt)bus).setConnectedComponentNumber(num);
        }

        protected ConnectedComponentImpl createComponent(int num, int size) {
            return new ConnectedComponentImpl(num, size, (Ref<NetworkImpl>)this.network.ref);
        }
    }

    static final class SynchronousComponentsManager
    extends AbstractSynchronousComponentsManager<SynchronousComponentImpl> {
        private final NetworkImpl network;

        private SynchronousComponentsManager(NetworkImpl network) {
            this.network = Objects.requireNonNull(network);
        }

        protected Network getNetwork() {
            return this.network;
        }

        protected void setComponentNumber(Bus bus, int num) {
            Objects.requireNonNull(bus);
            ((BusExt)bus).setSynchronousComponentNumber(num);
        }

        protected SynchronousComponentImpl createComponent(int num, int size) {
            return new SynchronousComponentImpl(num, size, (Ref<NetworkImpl>)this.network.ref);
        }
    }

    class DanglingLinePair {
        String id;
        String name;
        String dl1Id;
        String dl2Id;
        Map<String, String> aliases;
        Properties properties = new Properties();

        DanglingLinePair() {
        }
    }

    private static final class BusCache {
        private final Supplier<Stream<Bus>> busStream;
        private Map<String, Bus> cache;

        private BusCache(Supplier<Stream<Bus>> busStream) {
            this.busStream = busStream;
        }

        private void buildCache() {
            this.cache = (Map)this.busStream.get().collect(ImmutableMap.toImmutableMap(Identifiable::getId, (Function)Functions.identity()));
        }

        synchronized void invalidate() {
            this.cache = null;
        }

        private synchronized Map<String, Bus> getCache() {
            if (this.cache == null) {
                this.buildCache();
            }
            return this.cache;
        }

        Bus getBus(String id) {
            return this.getCache().get(id);
        }
    }
}

