/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractTapChanger;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerParent;
import com.powsybl.iidm.network.impl.RatioTapChangerStepImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerStepsReplacerImpl;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

class RatioTapChangerImpl
extends AbstractTapChanger<RatioTapChangerParent, RatioTapChangerImpl, RatioTapChangerStepImpl>
implements RatioTapChanger {
    private boolean loadTapChangingCapabilities;
    private RatioTapChanger.RegulationMode regulationMode;
    private final TDoubleArrayList regulationValue;

    RatioTapChangerImpl(RatioTapChangerParent parent, int lowTapPosition, List<RatioTapChangerStepImpl> steps, TerminalExt regulationTerminal, boolean loadTapChangingCapabilities, Integer tapPosition, Boolean regulating, RatioTapChanger.RegulationMode regulationMode, double regulationValue, double targetDeadband) {
        super(parent, lowTapPosition, steps, regulationTerminal, tapPosition, regulating, targetDeadband, "ratio tap changer");
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
        int variantArraySize = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantArraySize();
        this.regulationMode = regulationMode;
        this.regulationValue = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.regulationValue.add(regulationValue);
        }
    }

    protected void notifyUpdate(Supplier<String> attribute, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(((RatioTapChangerParent)this.parent).getTransformer(), attribute, oldValue, newValue);
    }

    protected void notifyUpdate(Supplier<String> attribute, String variantId, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(((RatioTapChangerParent)this.parent).getTransformer(), attribute, variantId, oldValue, newValue);
    }

    @Override
    protected RegulatingPoint createRegulatingPoint(int variantArraySize, boolean regulating) {
        return new RegulatingPoint(((RatioTapChangerParent)this.parent).getTransformer().getId(), () -> null, variantArraySize, regulating, true);
    }

    @Override
    protected Integer getRelativeNeutralPosition() {
        for (int i = 0; i < this.steps.size(); ++i) {
            RatioTapChangerStepImpl step = (RatioTapChangerStepImpl)this.steps.get(i);
            if (step.getRho() != 1.0) continue;
            return i;
        }
        return null;
    }

    public RatioTapChangerStepsReplacerImpl stepsReplacer() {
        return new RatioTapChangerStepsReplacerImpl(this);
    }

    public Optional<RatioTapChangerStep> getNeutralStep() {
        return this.relativeNeutralPosition != null ? Optional.of((RatioTapChangerStep)this.steps.get(this.relativeNeutralPosition)) : Optional.empty();
    }

    @Override
    public RatioTapChangerImpl setRegulating(boolean regulating) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)regulating, (boolean)this.loadTapChangingCapabilities, (Terminal)this.regulatingPoint.getRegulatingTerminal(), (RatioTapChanger.RegulationMode)this.getRegulationMode(), (double)this.getRegulationValue(), (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        HashSet tapChangers = new HashSet(((RatioTapChangerParent)this.parent).getAllTapChangers());
        tapChangers.remove(((RatioTapChangerParent)this.parent).getRatioTapChanger());
        ValidationUtil.checkOnlyOneTapChangerRegulatingEnabled((Validable)this.parent, tapChangers, (boolean)regulating, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        n.invalidateValidationLevel();
        return (RatioTapChangerImpl)super.setRegulating(regulating);
    }

    public boolean hasLoadTapChangingCapabilities() {
        return this.loadTapChangingCapabilities;
    }

    public RatioTapChangerImpl setLoadTapChangingCapabilities(boolean loadTapChangingCapabilities) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.isRegulating(), (boolean)loadTapChangingCapabilities, (Terminal)this.regulatingPoint.getRegulatingTerminal(), (RatioTapChanger.RegulationMode)this.getRegulationMode(), (double)this.getRegulationValue(), (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        boolean oldValue = this.loadTapChangingCapabilities;
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
        n.invalidateValidationLevel();
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".loadTapChangingCapabilities", oldValue, loadTapChangingCapabilities);
        return this;
    }

    public double getTargetV() {
        if (this.regulationMode != RatioTapChanger.RegulationMode.VOLTAGE) {
            return Double.NaN;
        }
        return this.getRegulationValue();
    }

    public RatioTapChangerImpl setTargetV(double targetV) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.isRegulating(), (boolean)this.loadTapChangingCapabilities, (Terminal)this.regulatingPoint.getRegulatingTerminal(), (RatioTapChanger.RegulationMode)RatioTapChanger.RegulationMode.VOLTAGE, (double)targetV, (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        double oldRegulationValue = this.regulationValue.set(variantIndex, targetV);
        RatioTapChanger.RegulationMode oldRegulationMode = this.regulationMode;
        if (!Double.isNaN(targetV)) {
            this.regulationMode = RatioTapChanger.RegulationMode.VOLTAGE;
        }
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".regulationValue", variantId, oldRegulationValue, targetV);
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".regulationMode", oldRegulationMode, this.regulationMode);
        return this;
    }

    public RatioTapChanger.RegulationMode getRegulationMode() {
        return this.regulationMode;
    }

    public RatioTapChangerImpl setRegulationMode(RatioTapChanger.RegulationMode regulationMode) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.isRegulating(), (boolean)this.loadTapChangingCapabilities, (Terminal)this.regulatingPoint.getRegulatingTerminal(), (RatioTapChanger.RegulationMode)regulationMode, (double)this.getRegulationValue(), (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        RatioTapChanger.RegulationMode oldValue = this.regulationMode;
        this.regulationMode = regulationMode;
        n.invalidateValidationLevel();
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".regulationMode", oldValue, regulationMode);
        return this;
    }

    public double getRegulationValue() {
        return this.regulationValue.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public RatioTapChangerImpl setRegulationValue(double regulationValue) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.isRegulating(), (boolean)this.loadTapChangingCapabilities, (Terminal)this.regulatingPoint.getRegulatingTerminal(), (RatioTapChanger.RegulationMode)this.getRegulationMode(), (double)regulationValue, (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        double oldValue = this.regulationValue.set(variantIndex, regulationValue);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".regulationValue", variantId, oldValue, regulationValue);
        return this;
    }

    @Override
    public RatioTapChangerImpl setRegulationTerminal(Terminal regulationTerminal) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.isRegulating(), (boolean)this.loadTapChangingCapabilities, (Terminal)regulationTerminal, (RatioTapChanger.RegulationMode)this.getRegulationMode(), (double)this.getRegulationValue(), (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        n.invalidateValidationLevel();
        return (RatioTapChangerImpl)super.setRegulationTerminal(regulationTerminal);
    }

    public void remove() {
        this.regulatingPoint.remove();
        ((RatioTapChangerParent)this.parent).setRatioTapChanger(null);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.regulationValue.ensureCapacity(this.regulationValue.size() + number);
        for (int i = 0; i < number; ++i) {
            this.regulationValue.add(this.regulationValue.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.regulationValue.remove(this.regulationValue.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.regulationValue.set(index, this.regulationValue.get(sourceIndex));
        }
    }

    @Override
    protected String getTapChangerAttribute() {
        return "ratio" + ((RatioTapChangerParent)this.parent).getTapChangerAttribute();
    }

    public Map<Integer, RatioTapChangerStep> getAllSteps() {
        HashMap<Integer, RatioTapChangerStep> allSteps = new HashMap<Integer, RatioTapChangerStep>();
        for (int i = 0; i < this.steps.size(); ++i) {
            allSteps.put(i + this.lowTapPosition, (RatioTapChangerStep)this.steps.get(i));
        }
        return allSteps;
    }
}

