/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import com.powsybl.iidm.network.ReactiveLimitsKind;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

class ReactiveCapabilityCurveImpl
implements ReactiveCapabilityCurve {
    private final TreeMap<Double, ReactiveCapabilityCurve.Point> points;

    ReactiveCapabilityCurveImpl(TreeMap<Double, ReactiveCapabilityCurve.Point> points) {
        if (points.size() < 2) {
            throw new IllegalStateException("Points size must be >= 2");
        }
        this.points = points;
    }

    public Collection<ReactiveCapabilityCurve.Point> getPoints() {
        return Collections.unmodifiableCollection(this.points.values());
    }

    public int getPointCount() {
        return this.points.size();
    }

    public double getMinP() {
        return this.points.firstKey();
    }

    public double getMaxP() {
        return this.points.lastKey();
    }

    public ReactiveLimitsKind getKind() {
        return ReactiveLimitsKind.CURVE;
    }

    public double getMinQ(double p) {
        if (this.points.size() < 2) {
            throw new IllegalStateException("points size should be >= 2");
        }
        ReactiveCapabilityCurve.Point pt = this.points.get(p);
        if (pt != null) {
            return pt.getMinQ();
        }
        Map.Entry<Double, ReactiveCapabilityCurve.Point> e1 = this.points.floorEntry(p);
        Map.Entry<Double, ReactiveCapabilityCurve.Point> e2 = this.points.ceilingEntry(p);
        if (e1 == null && e2 != null) {
            return e2.getValue().getMinQ();
        }
        if (e1 != null && e2 == null) {
            return e1.getValue().getMinQ();
        }
        if (e1 != null && e2 != null) {
            ReactiveCapabilityCurve.Point p1 = e1.getValue();
            ReactiveCapabilityCurve.Point p2 = e2.getValue();
            return p1.getMinQ() + (p2.getMinQ() - p1.getMinQ()) / (p2.getP() - p1.getP()) * (p - p1.getP());
        }
        throw new IllegalStateException();
    }

    public double getMaxQ(double p) {
        if (this.points.size() < 2) {
            throw new IllegalStateException("points size should be >= 2");
        }
        ReactiveCapabilityCurve.Point pt = this.points.get(p);
        if (pt != null) {
            return pt.getMaxQ();
        }
        Map.Entry<Double, ReactiveCapabilityCurve.Point> e1 = this.points.floorEntry(p);
        Map.Entry<Double, ReactiveCapabilityCurve.Point> e2 = this.points.ceilingEntry(p);
        if (e1 == null && e2 != null) {
            return e2.getValue().getMaxQ();
        }
        if (e1 != null && e2 == null) {
            return e1.getValue().getMaxQ();
        }
        if (e1 != null && e2 != null) {
            ReactiveCapabilityCurve.Point p1 = e1.getValue();
            ReactiveCapabilityCurve.Point p2 = e2.getValue();
            return p1.getMaxQ() + (p2.getMaxQ() - p1.getMaxQ()) / (p2.getP() - p1.getP()) * (p - p1.getP());
        }
        throw new IllegalStateException();
    }

    static class PointImpl
    implements ReactiveCapabilityCurve.Point {
        private double p;
        private double minQ;
        private double maxQ;

        PointImpl(double p, double minQ, double maxQ) {
            this.p = p;
            this.minQ = minQ;
            this.maxQ = maxQ;
        }

        public double getP() {
            return this.p;
        }

        public double getMinQ() {
            return this.minQ;
        }

        public double getMaxQ() {
            return this.maxQ;
        }
    }
}

