/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.impl.VariantContext;

public class ThreadLocalMultiVariantContext
implements VariantContext {
    private final ThreadLocal<Integer> index = ThreadLocal.withInitial(() -> null);

    @Override
    public int getVariantIndex() {
        Integer i = this.index.get();
        if (i == null) {
            throw new PowsyblException("Variant index not set for current thread " + Thread.currentThread().getName());
        }
        return i;
    }

    @Override
    public void setVariantIndex(int index) {
        this.index.set(index);
    }

    public void reset() {
        this.index.remove();
    }

    @Override
    public void resetIfVariantIndexIs(int index) {
        Integer i = this.index.get();
        if (i != null && i == index) {
            this.index.remove();
        }
    }

    @Override
    public boolean isIndexSet() {
        return this.index.get() != null;
    }
}

