/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractBranchAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.TwoWindingsTransformerImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

class TwoWindingsTransformerAdderImpl
extends AbstractBranchAdder<TwoWindingsTransformerAdderImpl>
implements TwoWindingsTransformerAdder {
    private final SubstationImpl substation;
    private double r = Double.NaN;
    private double x = Double.NaN;
    private double g = 0.0;
    private double b = 0.0;
    private double ratedU1 = Double.NaN;
    private double ratedU2 = Double.NaN;
    private double ratedS = Double.NaN;

    TwoWindingsTransformerAdderImpl(SubstationImpl substation) {
        this.substation = substation;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.substation.getNetwork();
    }

    @Override
    protected String getTypeDescription() {
        return "2 windings transformer";
    }

    public TwoWindingsTransformerAdder setR(double r) {
        this.r = r;
        return this;
    }

    public TwoWindingsTransformerAdder setX(double x) {
        this.x = x;
        return this;
    }

    public TwoWindingsTransformerAdder setB(double b) {
        this.b = b;
        return this;
    }

    public TwoWindingsTransformerAdder setG(double g) {
        this.g = g;
        return this;
    }

    public TwoWindingsTransformerAdder setRatedU1(double ratedU1) {
        this.ratedU1 = ratedU1;
        return this;
    }

    public TwoWindingsTransformerAdder setRatedU2(double ratedU2) {
        this.ratedU2 = ratedU2;
        return this;
    }

    public TwoWindingsTransformerAdder setRatedS(double ratedS) {
        this.ratedS = ratedS;
        return this;
    }

    public TwoWindingsTransformer add() {
        String id = this.checkAndGetUniqueId();
        this.checkConnectableBuses();
        VoltageLevelExt voltageLevel1 = this.checkAndGetVoltageLevel1();
        VoltageLevelExt voltageLevel2 = this.checkAndGetVoltageLevel2();
        if (voltageLevel1.getSubstation().map(s -> s != this.substation).orElse(true).booleanValue() || voltageLevel2.getSubstation().map(s -> s != this.substation).orElse(true).booleanValue()) {
            throw new ValidationException((Validable)this, "the 2 windings of the transformer shall belong to the substation '" + this.substation.getId() + "' ('" + voltageLevel1.getSubstation().map(Identifiable::getId).orElse("null") + "', '" + voltageLevel2.getSubstation().map(Identifiable::getId).orElse("null") + "')");
        }
        if (Double.isNaN(this.ratedU1)) {
            this.ratedU1 = voltageLevel1.getNominalV();
        }
        if (Double.isNaN(this.ratedU2)) {
            this.ratedU2 = voltageLevel2.getNominalV();
        }
        TerminalExt terminal1 = this.checkAndGetTerminal1();
        TerminalExt terminal2 = this.checkAndGetTerminal2();
        ValidationUtil.checkR((Validable)this, (double)this.r);
        ValidationUtil.checkX((Validable)this, (double)this.x);
        ValidationUtil.checkG((Validable)this, (double)this.g);
        ValidationUtil.checkB((Validable)this, (double)this.b);
        ValidationUtil.checkRatedU1((Validable)this, (double)this.ratedU1);
        ValidationUtil.checkRatedU2((Validable)this, (double)this.ratedU2);
        ValidationUtil.checkRatedS((Validable)this, (double)this.ratedS);
        TwoWindingsTransformerImpl transformer = new TwoWindingsTransformerImpl(this.substation.getNetworkRef(), id, this.getName(), this.isFictitious(), voltageLevel1.getSubstation().orElse(null), this.r, this.x, this.g, this.b, this.ratedU1, this.ratedU2, this.ratedS);
        transformer.addTerminal(terminal1);
        transformer.addTerminal(terminal2);
        voltageLevel1.attach(terminal1, true);
        voltageLevel2.attach(terminal2, true);
        voltageLevel1.attach(terminal1, false);
        voltageLevel2.attach(terminal2, false);
        this.getNetwork().getIndex().checkAndAdd(transformer);
        this.getNetwork().getListeners().notifyCreation(transformer);
        return transformer;
    }
}

