/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.Sets;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Set;

final class VoltageLevels {
    static final Set<IdentifiableType> MULTIPLE_TERMINALS_CONNECTABLE_TYPES = Sets.immutableEnumSet((Enum)IdentifiableType.LINE, (Enum[])new IdentifiableType[]{IdentifiableType.TWO_WINDINGS_TRANSFORMER, IdentifiableType.THREE_WINDINGS_TRANSFORMER});

    private VoltageLevels() {
    }

    static void checkRemovability(VoltageLevel voltageLevel) {
        Network network = voltageLevel.getNetwork();
        for (Connectable connectable : voltageLevel.getConnectables()) {
            IdentifiableType type = connectable.getType();
            if (MULTIPLE_TERMINALS_CONNECTABLE_TYPES.contains(type)) {
                throw new IllegalStateException("The voltage level '" + voltageLevel.getId() + "' cannot be removed because of a remaining " + type);
            }
            if (type != IdentifiableType.HVDC_CONVERTER_STATION || network.getHvdcLine((HvdcConverterStation)connectable) == null) continue;
            throw new IllegalStateException("The voltage level '" + voltageLevel.getId() + "' cannot be removed because of a remaining HVDC line");
        }
    }
}

