/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.extensions.HvdcOperatorActivePowerRange;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import gnu.trove.list.array.TFloatArrayList;
import java.util.Objects;

public class HvdcOperatorActivePowerRangeImpl
extends AbstractMultiVariantIdentifiableExtension<HvdcLine>
implements HvdcOperatorActivePowerRange {
    private TFloatArrayList oprFromCS1toCS2;
    private TFloatArrayList oprFromCS2toCS1;

    public HvdcOperatorActivePowerRangeImpl(HvdcLine hvdcLine, float oprFromCS1toCS2, float oprFromCS2toCS1) {
        super(hvdcLine);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.oprFromCS1toCS2 = new TFloatArrayList(variantArraySize);
        this.oprFromCS2toCS1 = new TFloatArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.oprFromCS1toCS2.add(this.checkOPR(oprFromCS1toCS2, hvdcLine.getConverterStation1(), hvdcLine.getConverterStation2()));
            this.oprFromCS2toCS1.add(this.checkOPR(oprFromCS2toCS1, hvdcLine.getConverterStation2(), hvdcLine.getConverterStation1()));
        }
    }

    public float getOprFromCS1toCS2() {
        return this.oprFromCS1toCS2.get(this.getVariantIndex());
    }

    public HvdcOperatorActivePowerRangeImpl setOprFromCS1toCS2(float oprFromCS1toCS2) {
        this.oprFromCS1toCS2.set(this.getVariantIndex(), this.checkOPR(oprFromCS1toCS2, ((HvdcLine)this.getExtendable()).getConverterStation1(), ((HvdcLine)this.getExtendable()).getConverterStation2()));
        return this;
    }

    public float getOprFromCS2toCS1() {
        return this.oprFromCS2toCS1.get(this.getVariantIndex());
    }

    public HvdcOperatorActivePowerRangeImpl setOprFromCS2toCS1(float oprFromCS2toCS1) {
        this.oprFromCS2toCS1.set(this.getVariantIndex(), this.checkOPR(oprFromCS2toCS1, ((HvdcLine)this.getExtendable()).getConverterStation1(), ((HvdcLine)this.getExtendable()).getConverterStation2()));
        return this;
    }

    private float checkOPR(float opr, HvdcConverterStation<?> from, HvdcConverterStation<?> to) {
        if (!Float.isNaN(opr) && opr < 0.0f) {
            String message = "OPR from " + from.getId() + " to " + to.getId() + " must be greater than 0 (current value " + Float.toString(opr) + ").";
            throw new IllegalArgumentException(message);
        }
        return opr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HvdcOperatorActivePowerRangeImpl that = (HvdcOperatorActivePowerRangeImpl)o;
        return Float.compare(that.getOprFromCS1toCS2(), this.getOprFromCS1toCS2()) == 0 && Float.compare(that.getOprFromCS2toCS1(), this.getOprFromCS2toCS1()) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.getOprFromCS1toCS2()), Float.valueOf(this.getOprFromCS2toCS1()));
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.oprFromCS1toCS2.ensureCapacity(this.oprFromCS1toCS2.size() + number);
        this.oprFromCS2toCS1.ensureCapacity(this.oprFromCS2toCS1.size() + number);
        for (int i = 0; i < number; ++i) {
            this.oprFromCS1toCS2.add(this.oprFromCS1toCS2.get(sourceIndex));
            this.oprFromCS2toCS1.add(this.oprFromCS2toCS1.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.oprFromCS1toCS2.remove(this.oprFromCS1toCS2.size() - number, number);
        this.oprFromCS2toCS1.remove(this.oprFromCS2toCS1.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.oprFromCS1toCS2.set(index, this.oprFromCS1toCS2.get(sourceIndex));
            this.oprFromCS2toCS1.set(index, this.oprFromCS2toCS1.get(sourceIndex));
        }
    }
}

