/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.extensions.PilotPointAdder;
import com.powsybl.iidm.network.impl.extensions.ControlZoneAdderImpl;
import com.powsybl.iidm.network.impl.extensions.PilotPointImpl;
import java.util.List;
import java.util.Objects;

public class PilotPointAdderImpl
implements PilotPointAdder {
    private final ControlZoneAdderImpl parent;
    private List<String> busbarSectionsOrBusesIds;
    private double targetV = Double.NaN;

    PilotPointAdderImpl(ControlZoneAdderImpl parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    public PilotPointAdderImpl withBusbarSectionsOrBusesIds(List<String> busbarSectionsOrBusesIds) {
        this.busbarSectionsOrBusesIds = Objects.requireNonNull(busbarSectionsOrBusesIds);
        return this;
    }

    public PilotPointAdderImpl withTargetV(double targetV) {
        this.targetV = targetV;
        return this;
    }

    public ControlZoneAdderImpl add() {
        if (this.busbarSectionsOrBusesIds.isEmpty()) {
            throw new PowsyblException("Empty busbar section or bus ID list");
        }
        for (String busbarSectionsOrBusesId : this.busbarSectionsOrBusesIds) {
            if (busbarSectionsOrBusesId != null) continue;
            throw new PowsyblException("Null busbar section or bus ID");
        }
        if (Double.isNaN(this.targetV)) {
            throw new PowsyblException("Invalid target voltage");
        }
        this.parent.setPilotPoint(new PilotPointImpl(this.busbarSectionsOrBusesIds, this.targetV));
        return this.parent;
    }
}

