/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import gnu.trove.list.array.TDoubleArrayList;

public class RemoteReactivePowerControlImpl
extends AbstractMultiVariantIdentifiableExtension<Generator>
implements RemoteReactivePowerControl {
    private TDoubleArrayList targetQ;
    private final Terminal regulatingTerminal;
    private TBooleanArrayList enabled;

    public RemoteReactivePowerControlImpl(Generator generator, double targetQ, Terminal regulatingTerminal, boolean enabled) {
        super(generator);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.targetQ = new TDoubleArrayList();
        this.regulatingTerminal = regulatingTerminal;
        this.enabled = new TBooleanArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.targetQ.add(targetQ);
            this.enabled.add(enabled);
        }
    }

    public double getTargetQ() {
        return this.targetQ.get(this.getVariantIndex());
    }

    public RemoteReactivePowerControl setTargetQ(double targetQ) {
        this.targetQ.set(this.getVariantIndex(), targetQ);
        return this;
    }

    public RemoteReactivePowerControl setEnabled(boolean enabled) {
        this.enabled.set(this.getVariantIndex(), enabled);
        return this;
    }

    public Terminal getRegulatingTerminal() {
        return this.regulatingTerminal;
    }

    public boolean isEnabled() {
        return this.enabled.get(this.getVariantIndex());
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.enabled.ensureCapacity(this.enabled.size() + number);
        this.targetQ.ensureCapacity(this.targetQ.size() + number);
        for (int i = 0; i < number; ++i) {
            this.enabled.add(this.enabled.get(sourceIndex));
            this.targetQ.add(this.targetQ.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.enabled.remove(this.enabled.size() - number, number);
        this.targetQ.remove(this.targetQ.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.targetQ.set(index, this.targetQ.get(sourceIndex));
            this.enabled.set(index, this.enabled.get(sourceIndex));
        }
    }
}

