/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalBuilder;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

abstract class AbstractInjectionAdder<T extends AbstractInjectionAdder<T>>
extends AbstractIdentifiableAdder<T> {
    private Integer node;
    private String bus;
    private String connectableBus;
    protected VoltageLevelExt voltageLevel;

    AbstractInjectionAdder() {
    }

    public T setNode(int node) {
        this.node = node;
        return (T)this;
    }

    public T setBus(String bus) {
        this.bus = bus;
        return (T)this;
    }

    public T setConnectableBus(String connectableBus) {
        this.connectableBus = connectableBus;
        return (T)this;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.voltageLevel.getNetwork();
    }

    protected Ref<NetworkImpl> getNetworkRef() {
        return this.voltageLevel.getNetworkRef();
    }

    protected TerminalExt checkAndGetTerminal() {
        return new TerminalBuilder(this.getNetworkRef(), this, null).setNode(this.node).setBus(this.bus).setConnectableBus(this.connectableBus).build();
    }
}

