/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TapChangerParent;
import com.powsybl.iidm.network.impl.TapChangerStepImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTapChangerAdderImpl<A extends AbstractTapChangerAdderImpl<A, H, T, S>, H extends TapChangerParent, T extends TapChanger<T, ?, ?, ?>, S extends TapChangerStepImpl<S>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTapChangerAdderImpl.class);
    protected final H parent;
    private int lowTapPosition = 0;
    private Integer tapPosition;
    protected final List<S> steps;
    private double regulationValue = Double.NaN;
    private boolean regulating = false;
    private double targetDeadband = Double.NaN;
    private TerminalExt regulationTerminal;

    protected AbstractTapChangerAdderImpl(H parent) {
        this.parent = parent;
        this.steps = new ArrayList<S>();
    }

    public A setLowTapPosition(int lowTapPosition) {
        this.lowTapPosition = lowTapPosition;
        return this.self();
    }

    public A setTapPosition(int tapPosition) {
        this.tapPosition = tapPosition;
        return this.self();
    }

    public A setRegulationValue(double regulationValue) {
        this.regulationValue = regulationValue;
        return this.self();
    }

    public A setRegulating(boolean regulating) {
        this.regulating = regulating;
        return this.self();
    }

    public A setTargetDeadband(double targetDeadband) {
        this.targetDeadband = targetDeadband;
        return this.self();
    }

    public A setRegulationTerminal(Terminal regulationTerminal) {
        this.regulationTerminal = (TerminalExt)regulationTerminal;
        return this.self();
    }

    NetworkImpl getNetwork() {
        return this.parent.getNetwork();
    }

    public T add() {
        NetworkImpl network = this.getNetwork();
        if (this.tapPosition == null) {
            ValidationUtil.throwExceptionOrLogError(this.parent, (String)"tap position is not set", (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode());
            network.setValidationLevelIfGreaterThan(ValidationLevel.EQUIPMENT);
        }
        if (this.steps.isEmpty()) {
            throw new ValidationException(this.parent, this.getValidableType() + " should have at least one step");
        }
        if (this.tapPosition != null) {
            int highTapPosition = this.lowTapPosition + this.steps.size() - 1;
            if (this.tapPosition < this.lowTapPosition || this.tapPosition > highTapPosition) {
                ValidationUtil.throwExceptionOrLogError(this.parent, (String)("incorrect tap position " + this.tapPosition + " [" + this.lowTapPosition + ", " + highTapPosition + "]"), (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode());
                network.setValidationLevelIfGreaterThan(ValidationLevel.EQUIPMENT);
            }
        }
        network.setValidationLevelIfGreaterThan(this.checkTapChangerRegulation(this.parent, this.regulationValue, this.regulating, this.regulationTerminal));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkTargetDeadband(this.parent, (String)this.getValidableType(), (boolean)this.regulating, (double)this.targetDeadband, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        T tapChanger = this.createTapChanger(this.parent, this.lowTapPosition, this.steps, this.regulationTerminal, this.tapPosition, this.regulating, this.regulationValue, this.targetDeadband);
        HashSet otherTapChangers = new HashSet(this.parent.getAllTapChangers());
        otherTapChangers.remove(tapChanger);
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkOnlyOneTapChangerRegulatingEnabled(this.parent, otherTapChangers, (boolean)this.regulating, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        if (this.parent.hasPhaseTapChanger() && this.parent.hasRatioTapChanger()) {
            LOGGER.warn("{} has both Ratio and Phase Tap Changer", this.parent);
            ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)network.getReportNodeContext().getReportNode().newReportNode().withMessageTemplate("validationWarning", "${parent} has both Ratio and Phase Tap Changer.")).withUntypedValue("parent", this.parent.getMessageHeader())).withSeverity(TypedValue.WARN_SEVERITY)).add();
        }
        return tapChanger;
    }

    protected abstract T createTapChanger(H var1, int var2, List<S> var3, TerminalExt var4, Integer var5, boolean var6, double var7, double var9);

    protected abstract A self();

    protected abstract ValidationLevel checkTapChangerRegulation(H var1, double var2, boolean var4, TerminalExt var5);

    protected abstract String getValidableType();
}

