/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.ref.RefChain;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AreaImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AreaAdderImpl
extends AbstractIdentifiableAdder<AreaAdderImpl>
implements AreaAdder {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private String areaType;
    private double interchangeTarget;
    private final Set<VoltageLevel> voltageLevels;
    private final Map<Terminal, Boolean> terminalAreaBoundaries;
    private final Map<Boundary, Boolean> boundaryAreaBoundaries;

    AreaAdderImpl(Ref<NetworkImpl> networkRef, RefChain<SubnetworkImpl> subnetworkRef) {
        this.networkRef = networkRef;
        this.subnetworkRef = subnetworkRef;
        this.terminalAreaBoundaries = new HashMap<Terminal, Boolean>();
        this.boundaryAreaBoundaries = new HashMap<Boundary, Boolean>();
        this.voltageLevels = new HashSet<VoltageLevel>();
        this.interchangeTarget = Double.NaN;
    }

    @Override
    public NetworkImpl getNetwork() {
        return (NetworkImpl)this.networkRef.get();
    }

    public AreaAdder setAreaType(String areaType) {
        this.areaType = areaType;
        return this;
    }

    public AreaAdder setInterchangeTarget(double interchangeTarget) {
        this.interchangeTarget = interchangeTarget;
        return this;
    }

    public AreaAdder addVoltageLevel(VoltageLevel voltageLevel) {
        this.voltageLevels.add(voltageLevel);
        return this;
    }

    public AreaAdder addAreaBoundary(Terminal terminal, boolean ac) {
        this.terminalAreaBoundaries.put(terminal, ac);
        return this;
    }

    public AreaAdder addAreaBoundary(Boundary boundary, boolean ac) {
        this.boundaryAreaBoundaries.put(boundary, ac);
        return this;
    }

    protected Set<VoltageLevel> getVoltageLevels() {
        return this.voltageLevels;
    }

    public Area add() {
        String id = this.checkAndGetUniqueId();
        AreaImpl area = new AreaImpl(this.networkRef, this.subnetworkRef, id, this.getName(), this.isFictitious(), this.areaType, this.interchangeTarget);
        this.terminalAreaBoundaries.forEach((terminal, ac) -> area.newAreaBoundary().setTerminal((Terminal)terminal).setAc(ac.booleanValue()).add());
        this.boundaryAreaBoundaries.forEach((boundary, ac) -> area.newAreaBoundary().setBoundary((Boundary)boundary).setAc(ac.booleanValue()).add());
        this.voltageLevels.forEach(area::addVoltageLevel);
        this.getNetwork().getIndex().checkAndAdd(area);
        this.getNetwork().getListeners().notifyCreation(area);
        return area;
    }

    @Override
    protected String getTypeDescription() {
        return "Area";
    }
}

