/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.Iterables;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaBoundary;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DefaultNetworkListener;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkListener;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.AreaBoundaryAdderImpl;
import com.powsybl.iidm.network.impl.AreaBoundaryImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AreaImpl
extends AbstractIdentifiable<Area>
implements Area {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private final String areaType;
    private final List<AreaBoundary> areaBoundaries;
    private final Set<VoltageLevel> voltageLevels;
    protected boolean removed = false;
    private final TDoubleArrayList interchangeTarget;
    private final NetworkListener areaListener;

    void moveListener(NetworkImpl fromNetwork, NetworkImpl toNetwork) {
        fromNetwork.removeListener(this.areaListener);
        toNetwork.addListener(this.areaListener);
    }

    AreaImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef, String id, String name, boolean fictitious, String areaType, double interchangeTarget) {
        super(id, name, fictitious);
        this.networkRef = Objects.requireNonNull(ref);
        this.subnetworkRef = subnetworkRef;
        this.areaType = Objects.requireNonNull(areaType);
        this.voltageLevels = new LinkedHashSet<VoltageLevel>();
        this.areaBoundaries = new ArrayList<AreaBoundary>();
        int variantArraySize = ((NetworkImpl)this.networkRef.get()).getVariantManager().getVariantArraySize();
        this.interchangeTarget = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.interchangeTarget.add(interchangeTarget);
        }
        this.areaListener = new AreaListener();
        this.getNetwork().addListener(this.areaListener);
    }

    @Override
    public NetworkImpl getNetwork() {
        this.throwIfRemoved("network");
        return (NetworkImpl)this.networkRef.get();
    }

    public Network getParentNetwork() {
        this.throwIfRemoved("network");
        return Optional.ofNullable((Network)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    @Override
    protected String getTypeDescription() {
        return "Area";
    }

    public String getAreaType() {
        this.throwIfRemoved("area type");
        return this.areaType;
    }

    public Iterable<VoltageLevel> getVoltageLevels() {
        this.throwIfRemoved("voltage levels");
        return this.voltageLevels;
    }

    public Stream<VoltageLevel> getVoltageLevelStream() {
        this.throwIfRemoved("voltage levels");
        return this.voltageLevels.stream();
    }

    public OptionalDouble getInterchangeTarget() {
        this.throwIfRemoved("interchange target");
        double target = this.interchangeTarget.get(this.getNetwork().getVariantIndex());
        if (Double.isNaN(target)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(target);
    }

    public Area setInterchangeTarget(double interchangeTarget) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        double oldValue = this.interchangeTarget.set(variantIndex, interchangeTarget);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("interchangeTarget", variantId, oldValue, interchangeTarget);
        return this;
    }

    public double getAcInterchange() {
        this.throwIfRemoved("AC interchange");
        return this.getInterchange(AreaBoundary::isAc);
    }

    public double getDcInterchange() {
        this.throwIfRemoved("DC interchange");
        return this.getInterchange(areaBoundary -> !areaBoundary.isAc());
    }

    public double getInterchange() {
        this.throwIfRemoved("total interchange");
        return this.getInterchange(areaBoundary -> true);
    }

    double getInterchange(Predicate<AreaBoundary> predicate) {
        return this.areaBoundaries.stream().filter(predicate).mapToDouble(AreaBoundary::getP).filter(p -> !Double.isNaN(p)).sum();
    }

    public Area addVoltageLevel(VoltageLevel voltageLevel) {
        Objects.requireNonNull(voltageLevel);
        if (this.voltageLevels.add(voltageLevel)) {
            voltageLevel.addArea((Area)this);
        }
        return this;
    }

    public Area removeVoltageLevel(VoltageLevel voltageLevel) {
        Objects.requireNonNull(voltageLevel);
        this.voltageLevels.remove(voltageLevel);
        if (Iterables.contains((Iterable)voltageLevel.getAreas(), (Object)this)) {
            voltageLevel.removeArea((Area)this);
        }
        return this;
    }

    public AreaBoundaryAdderImpl newAreaBoundary() {
        return new AreaBoundaryAdderImpl(this);
    }

    public Area removeAreaBoundary(Terminal terminal) {
        Objects.requireNonNull(terminal);
        this.areaBoundaries.removeIf(b -> Objects.equals(b.getTerminal().orElse(null), terminal));
        return this;
    }

    public Area removeAreaBoundary(Boundary boundary) {
        Objects.requireNonNull(boundary);
        this.areaBoundaries.removeIf(b -> Objects.equals(b.getBoundary().orElse(null), boundary));
        return this;
    }

    public AreaBoundary getAreaBoundary(Boundary boundary) {
        Objects.requireNonNull(boundary);
        return this.areaBoundaries.stream().filter(ab -> Objects.equals(ab.getBoundary().orElse(null), boundary)).findFirst().orElse(null);
    }

    public AreaBoundary getAreaBoundary(Terminal terminal) {
        Objects.requireNonNull(terminal);
        return this.areaBoundaries.stream().filter(ab -> Objects.equals(ab.getTerminal().orElse(null), terminal)).findFirst().orElse(null);
    }

    public Iterable<AreaBoundary> getAreaBoundaries() {
        this.throwIfRemoved("area boundaries");
        return this.areaBoundaries;
    }

    public Stream<AreaBoundary> getAreaBoundaryStream() {
        this.throwIfRemoved("area boundaries");
        return this.areaBoundaries.stream();
    }

    protected void addAreaBoundary(AreaBoundaryImpl areaBoundary) {
        Optional<Terminal> terminal = areaBoundary.getTerminal();
        Optional<Boundary> boundary = areaBoundary.getBoundary();
        boundary.ifPresent(b -> this.checkBoundaryNetwork(b.getDanglingLine().getParentNetwork(), "Boundary of DanglingLine" + b.getDanglingLine().getId()));
        terminal.ifPresent(t -> this.checkBoundaryNetwork(t.getConnectable().getParentNetwork(), "Terminal of connectable " + t.getConnectable().getId()));
        this.areaBoundaries.add(areaBoundary);
    }

    void checkBoundaryNetwork(Network network, String boundaryTypeAndId) {
        if (this.getParentNetwork() != network) {
            throw new PowsyblException(boundaryTypeAndId + " cannot be added to Area " + this.getId() + " boundaries. It does not belong to the same network or subnetwork.");
        }
    }

    public void remove() {
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        network.getIndex().remove(this);
        for (VoltageLevel voltageLevel : new HashSet<VoltageLevel>(this.voltageLevels)) {
            voltageLevel.removeArea((Area)this);
        }
        network.getListeners().notifyAfterRemoval(this.id);
        network.removeListener(this.areaListener);
        this.removed = true;
    }

    void throwIfRemoved(String attribute) {
        if (this.removed) {
            throw new PowsyblException("Cannot access " + attribute + " of removed area " + this.id);
        }
    }

    protected void notifyUpdate(String attribute, String variantId, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(this, attribute, variantId, oldValue, newValue);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.interchangeTarget.ensureCapacity(this.interchangeTarget.size() + number);
        for (int i = 0; i < number; ++i) {
            this.interchangeTarget.add(this.interchangeTarget.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.interchangeTarget.remove(this.interchangeTarget.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.interchangeTarget.set(index, this.interchangeTarget.get(sourceIndex));
        }
    }

    private final class AreaListener
    extends DefaultNetworkListener {
        private AreaListener() {
        }

        public void beforeRemoval(Identifiable<?> identifiable) {
            if (identifiable instanceof DanglingLine) {
                DanglingLine danglingLine = (DanglingLine)identifiable;
                AreaImpl.this.removeAreaBoundary(danglingLine.getBoundary());
            } else if (identifiable instanceof Connectable) {
                Connectable connectable = (Connectable)identifiable;
                connectable.getTerminals().forEach(AreaImpl.this::removeAreaBoundary);
            }
        }
    }
}

