/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.impl.NodeBreakerVoltageLevel;
import com.powsybl.iidm.network.impl.SwitchImpl;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;

public final class ConnectDisconnectUtil {
    private ConnectDisconnectUtil() {
    }

    static boolean connectAllTerminals(Identifiable<?> identifiable, List<? extends Terminal> terminals, Predicate<Switch> isTypeSwitchToOperate, ReportNode reportNode) {
        boolean isAlreadyConnected = true;
        boolean isNowConnected = true;
        HashSet<SwitchImpl> switchForDisconnection = new HashSet<SwitchImpl>();
        for (Terminal terminal : terminals) {
            if (terminal.isConnected()) {
                ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("alreadyConnectedTerminal", "A terminal of identifiable ${identifiable} is already connected.")).withUntypedValue("identifiable", identifiable.getId())).withSeverity(TypedValue.WARN_SEVERITY)).add();
                continue;
            }
            isAlreadyConnected = false;
            VoltageLevel voltageLevel = terminal.getVoltageLevel();
            if (voltageLevel instanceof NodeBreakerVoltageLevel) {
                NodeBreakerVoltageLevel nodeBreakerVoltageLevel = (NodeBreakerVoltageLevel)voltageLevel;
                isNowConnected = nodeBreakerVoltageLevel.getConnectingSwitches(terminal, isTypeSwitchToOperate, switchForDisconnection);
            }
            if (isNowConnected) continue;
            return false;
        }
        if (isAlreadyConnected) {
            return false;
        }
        for (Terminal terminal : terminals) {
            if (terminal.isConnected() || terminal.getVoltageLevel().getTopologyKind() != TopologyKind.BUS_BREAKER) continue;
            isNowConnected = isNowConnected && terminal.connect(isTypeSwitchToOperate);
        }
        switchForDisconnection.forEach(sw -> sw.setOpen(false));
        return isNowConnected;
    }

    static boolean disconnectAllTerminals(Identifiable<?> identifiable, List<? extends Terminal> terminals, Predicate<Switch> isSwitchOpenable, ReportNode reportNode) {
        boolean isAlreadyDisconnected = true;
        boolean isNowDisconnected = true;
        HashSet<SwitchImpl> switchForDisconnection = new HashSet<SwitchImpl>();
        for (Terminal terminal : terminals) {
            NodeBreakerVoltageLevel nodeBreakerVoltageLevel;
            if (!terminal.isConnected()) {
                ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("alreadyDisconnectedTerminal", "A terminal of identifiable ${identifiable} is already disconnected.")).withUntypedValue("identifiable", identifiable.getId())).withSeverity(TypedValue.WARN_SEVERITY)).add();
                continue;
            }
            isAlreadyDisconnected = false;
            VoltageLevel voltageLevel = terminal.getVoltageLevel();
            if (!(voltageLevel instanceof NodeBreakerVoltageLevel) || (nodeBreakerVoltageLevel = (NodeBreakerVoltageLevel)voltageLevel).getDisconnectingSwitches(terminal, isSwitchOpenable, switchForDisconnection)) continue;
            return false;
        }
        if (isAlreadyDisconnected) {
            return false;
        }
        for (Terminal terminal : terminals) {
            if (!terminal.isConnected() || terminal.getVoltageLevel().getTopologyKind() != TopologyKind.BUS_BREAKER) continue;
            isNowDisconnected = isNowDisconnected && terminal.disconnect(isSwitchOpenable);
        }
        switchForDisconnection.forEach(sw -> sw.setOpen(true));
        return isNowDisconnected;
    }
}

