/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.NetworkListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkListenerList {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkListenerList.class);
    private final List<NetworkListener> listeners = new ArrayList<NetworkListener>();

    void add(NetworkListener listener) {
        this.listeners.add(listener);
    }

    void remove(NetworkListener listener) {
        this.listeners.remove(listener);
    }

    void notifyUpdate(Identifiable<?> identifiable, Supplier<String> attribute, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyUpdateListeners(identifiable, attribute.get(), oldValue, newValue);
        }
    }

    void notifyUpdate(Identifiable<?> identifiable, String attribute, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyUpdateListeners(identifiable, attribute, oldValue, newValue);
        }
    }

    private void notifyUpdateListeners(Identifiable<?> identifiable, String attribute, Object oldValue, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onUpdate(identifiable, attribute, oldValue, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyUpdate(Identifiable<?> identifiable, Supplier<String> attribute, String variantId, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyUpdateListeners(identifiable, attribute.get(), variantId, oldValue, newValue);
        }
    }

    void notifyUpdate(Identifiable<?> identifiable, String attribute, String variantId, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyUpdateListeners(identifiable, attribute, variantId, oldValue, newValue);
        }
    }

    private void notifyUpdateListeners(Identifiable<?> identifiable, String attribute, String variantId, Object oldValue, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onUpdate(identifiable, attribute, variantId, oldValue, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    public void notifyExtensionCreation(Extension<?> extension) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onExtensionCreation(extension);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    public void notifyExtensionBeforeRemoval(Extension<?> extension) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onExtensionBeforeRemoval(extension);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    public void notifyExtensionAfterRemoval(Identifiable<?> identifiable, String extensionName) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onExtensionAfterRemoval(identifiable, extensionName);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    public void notifyExtensionUpdate(Extension<?> extension, String attribute, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyExtensionUpdateListeners(extension, attribute, oldValue, newValue);
        }
    }

    private void notifyExtensionUpdateListeners(Extension<?> extension, String attribute, Object oldValue, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onExtensionUpdate(extension, attribute, oldValue, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyCreation(Identifiable<?> identifiable) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onCreation(identifiable);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyBeforeRemoval(Identifiable<?> identifiable) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.beforeRemoval(identifiable);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyAfterRemoval(String id) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.afterRemoval(id);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyElementAdded(Identifiable<?> identifiable, Supplier<String> attribute, Object newValue) {
        if (!this.listeners.isEmpty()) {
            this.notifyElementAdded(identifiable, attribute.get(), newValue);
        }
    }

    void notifyElementAdded(Identifiable<?> identifiable, String attribute, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onElementAdded(identifiable, attribute, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyElementReplaced(Identifiable<?> identifiable, Supplier<String> attribute, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyElementReplaced(identifiable, attribute.get(), oldValue, newValue);
        }
    }

    void notifyElementReplaced(Identifiable<?> identifiable, String attribute, Object oldValue, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onElementReplaced(identifiable, attribute, oldValue, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyElementRemoved(Identifiable<?> identifiable, Supplier<String> attribute, Object oldValue) {
        if (!this.listeners.isEmpty()) {
            this.notifyElementRemoved(identifiable, attribute.get(), oldValue);
        }
    }

    void notifyElementRemoved(Identifiable<?> identifiable, String attribute, Object oldValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onElementRemoved(identifiable, attribute, oldValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyVariantCreated(String sourceVariantId, String targetVariantId) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onVariantCreated(sourceVariantId, targetVariantId);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyVariantOverwritten(String sourceVariantId, String targetVariantId) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onVariantOverwritten(sourceVariantId, targetVariantId);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyVariantRemoved(String variantId) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onVariantRemoved(variantId);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }
}

