/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractTapChanger;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerParent;
import com.powsybl.iidm.network.impl.PhaseTapChangerStepImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerStepsReplacerImpl;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

class PhaseTapChangerImpl
extends AbstractTapChanger<PhaseTapChangerParent, PhaseTapChangerImpl, PhaseTapChangerStepImpl>
implements PhaseTapChanger {
    private PhaseTapChanger.RegulationMode regulationMode;
    private final TDoubleArrayList regulationValue;

    PhaseTapChangerImpl(PhaseTapChangerParent parent, int lowTapPosition, List<PhaseTapChangerStepImpl> steps, TerminalExt regulationTerminal, Integer tapPosition, Boolean regulating, PhaseTapChanger.RegulationMode regulationMode, double regulationValue, double targetDeadband) {
        super(parent, lowTapPosition, steps, regulationTerminal, tapPosition, regulating, targetDeadband, "phase tap changer");
        int variantArraySize = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantArraySize();
        this.regulationMode = regulationMode;
        this.regulationValue = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.regulationValue.add(regulationValue);
        }
    }

    protected void notifyUpdate(Supplier<String> attribute, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(((PhaseTapChangerParent)this.parent).getTransformer(), attribute, oldValue, newValue);
    }

    protected void notifyUpdate(Supplier<String> attribute, String variantId, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(((PhaseTapChangerParent)this.parent).getTransformer(), attribute, variantId, oldValue, newValue);
    }

    public PhaseTapChangerStepsReplacerImpl stepsReplacer() {
        return new PhaseTapChangerStepsReplacerImpl(this);
    }

    public Optional<PhaseTapChangerStep> getNeutralStep() {
        return this.relativeNeutralPosition != null ? Optional.of((PhaseTapChangerStep)this.steps.get(this.relativeNeutralPosition)) : Optional.empty();
    }

    @Override
    protected RegulatingPoint createRegulatingPoint(int variantArraySize, boolean regulating) {
        return new RegulatingPoint(((PhaseTapChangerParent)this.parent).getTransformer().getId(), () -> null, variantArraySize, regulating, false);
    }

    @Override
    protected Integer getRelativeNeutralPosition() {
        for (int i = 0; i < this.steps.size(); ++i) {
            PhaseTapChangerStepImpl step = (PhaseTapChangerStepImpl)this.steps.get(i);
            if (step.getRho() != 1.0 || step.getAlpha() != 0.0) continue;
            return i;
        }
        return null;
    }

    @Override
    public PhaseTapChangerImpl setRegulating(boolean regulating) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkPhaseTapChangerRegulation((Validable)this.parent, (PhaseTapChanger.RegulationMode)this.getRegulationMode(), (double)this.getRegulationValue(), (boolean)regulating, (Terminal)this.getRegulationTerminal(), (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        HashSet tapChangers = new HashSet(((PhaseTapChangerParent)this.parent).getAllTapChangers());
        tapChangers.remove(((PhaseTapChangerParent)this.parent).getPhaseTapChanger());
        ValidationUtil.checkOnlyOneTapChangerRegulatingEnabled((Validable)this.parent, tapChangers, (boolean)regulating, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        n.invalidateValidationLevel();
        return (PhaseTapChangerImpl)super.setRegulating(regulating);
    }

    public PhaseTapChanger.RegulationMode getRegulationMode() {
        return this.regulationMode;
    }

    public PhaseTapChangerImpl setRegulationMode(PhaseTapChanger.RegulationMode regulationMode) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkPhaseTapChangerRegulation((Validable)this.parent, (PhaseTapChanger.RegulationMode)regulationMode, (double)this.getRegulationValue(), (boolean)this.isRegulating(), (Terminal)this.getRegulationTerminal(), (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        PhaseTapChanger.RegulationMode oldValue = this.regulationMode;
        this.regulationMode = regulationMode;
        n.invalidateValidationLevel();
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".regulationMode", oldValue, regulationMode);
        return this;
    }

    public double getRegulationValue() {
        return this.regulationValue.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public PhaseTapChangerImpl setRegulationValue(double regulationValue) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkPhaseTapChangerRegulation((Validable)this.parent, (PhaseTapChanger.RegulationMode)this.regulationMode, (double)regulationValue, (boolean)this.isRegulating(), (Terminal)this.getRegulationTerminal(), (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        double oldValue = this.regulationValue.set(variantIndex, regulationValue);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".regulationValue", variantId, oldValue, regulationValue);
        return this;
    }

    @Override
    public PhaseTapChangerImpl setRegulationTerminal(Terminal regulationTerminal) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkPhaseTapChangerRegulation((Validable)this.parent, (PhaseTapChanger.RegulationMode)this.regulationMode, (double)this.getRegulationValue(), (boolean)this.isRegulating(), (Terminal)regulationTerminal, (Network)n, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        n.invalidateValidationLevel();
        return (PhaseTapChangerImpl)super.setRegulationTerminal(regulationTerminal);
    }

    public void remove() {
        this.regulatingPoint.remove();
        ((PhaseTapChangerParent)this.parent).setPhaseTapChanger(null);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.regulationValue.ensureCapacity(this.regulationValue.size() + number);
        for (int i = 0; i < number; ++i) {
            this.regulationValue.add(this.regulationValue.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.regulationValue.remove(this.regulationValue.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.regulationValue.set(index, this.regulationValue.get(sourceIndex));
        }
    }

    @Override
    protected String getTapChangerAttribute() {
        return "phase" + ((PhaseTapChangerParent)this.parent).getTapChangerAttribute();
    }

    public Map<Integer, PhaseTapChangerStep> getAllSteps() {
        HashMap<Integer, PhaseTapChangerStep> allSteps = new HashMap<Integer, PhaseTapChangerStep>();
        for (int i = 0; i < this.steps.size(); ++i) {
            allSteps.put(i + this.lowTapPosition, (PhaseTapChangerStep)this.steps.get(i));
        }
        return allSteps;
    }
}

