/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.ref.RefChain;
import com.powsybl.commons.ref.RefObj;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Ground;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkListener;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.ReportNodeContext;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.VariantManager;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageAngleLimitAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.AreaAdderImpl;
import com.powsybl.iidm.network.impl.AreaImpl;
import com.powsybl.iidm.network.impl.BatteryImpl;
import com.powsybl.iidm.network.impl.DanglingLineImpl;
import com.powsybl.iidm.network.impl.GeneratorImpl;
import com.powsybl.iidm.network.impl.LccConverterStationImpl;
import com.powsybl.iidm.network.impl.LoadImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorImpl;
import com.powsybl.iidm.network.impl.StaticVarCompensatorImpl;
import com.powsybl.iidm.network.impl.Subcomponent;
import com.powsybl.iidm.network.impl.SubstationAdderImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.VoltageAngleLimitImpl;
import com.powsybl.iidm.network.impl.VoltageLevelAdderImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.VscConverterStationImpl;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetworkImpl
extends AbstractNetwork {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubnetworkImpl.class);
    private final RefChain<NetworkImpl> rootNetworkRef;
    private final RefChain<SubnetworkImpl> ref;
    private final BusBreakerViewImpl busBreakerView = new BusBreakerViewImpl();
    private final BusViewImpl busView = new BusViewImpl();

    SubnetworkImpl(RefChain<NetworkImpl> rootNetworkRef, String id, String name, String sourceFormat) {
        super(id, name, sourceFormat);
        this.rootNetworkRef = Objects.requireNonNull(rootNetworkRef);
        this.ref = new RefChain((Ref)new RefObj((Object)this));
    }

    SubnetworkImpl(RefChain<NetworkImpl> rootNetworkRef, RefChain<SubnetworkImpl> subnetworkRef, String id, String name, String sourceFormat, ZonedDateTime caseDate) {
        super(id, name, sourceFormat);
        this.rootNetworkRef = Objects.requireNonNull(rootNetworkRef);
        this.ref = Objects.requireNonNull(subnetworkRef);
        this.ref.setRef((Ref)new RefObj((Object)this));
        this.setCaseDate(caseDate);
    }

    @Override
    public RefChain<NetworkImpl> getRootNetworkRef() {
        return this.rootNetworkRef;
    }

    protected RefChain<SubnetworkImpl> getRef() {
        return this.ref;
    }

    public final Collection<Network> getSubnetworks() {
        return Collections.emptyList();
    }

    public final Network getSubnetwork(String id) {
        return null;
    }

    @Override
    public NetworkImpl getNetwork() {
        return (NetworkImpl)this.rootNetworkRef.get();
    }

    public VariantManager getVariantManager() {
        return this.getNetwork().getVariantManager();
    }

    public void allowReportNodeContextMultiThreadAccess(boolean allow) {
        this.getNetwork().allowReportNodeContextMultiThreadAccess(allow);
    }

    public ReportNodeContext getReportNodeContext() {
        return this.getNetwork().getReportNodeContext();
    }

    private boolean contains(Identifiable<?> identifiable) {
        return identifiable == this || identifiable != null && identifiable.getParentNetwork() == this;
    }

    public Set<Country> getCountries() {
        return this.getCountryStream().collect(Collectors.toSet());
    }

    public int getCountryCount() {
        return (int)this.getCountryStream().count();
    }

    private Stream<Country> getCountryStream() {
        return this.getNetwork().getSubstationStream().filter(this::contains).map(s -> s.getCountry().orElse(null)).filter(Objects::nonNull).distinct();
    }

    public Iterable<String> getAreaTypes() {
        return this.getAreaTypeStream().toList();
    }

    public Stream<String> getAreaTypeStream() {
        return this.getAreaStream().map(Area::getAreaType).distinct();
    }

    public int getAreaTypeCount() {
        return (int)this.getAreaTypeStream().count();
    }

    public AreaAdder newArea() {
        return new AreaAdderImpl((Ref<NetworkImpl>)this.rootNetworkRef, this.ref);
    }

    public Iterable<Area> getAreas() {
        return this.getAreaStream().toList();
    }

    public Stream<Area> getAreaStream() {
        return this.getNetwork().getAreaStream().filter(this::contains);
    }

    public Area getArea(String id) {
        Area area = this.getNetwork().getArea(id);
        return this.contains((Identifiable<?>)area) ? area : null;
    }

    public int getAreaCount() {
        return (int)this.getAreaStream().count();
    }

    public SubstationAdder newSubstation() {
        return new SubstationAdderImpl((Ref<NetworkImpl>)this.rootNetworkRef, (Ref<SubnetworkImpl>)this.ref);
    }

    public Iterable<Substation> getSubstations() {
        return this.getSubstationStream().toList();
    }

    public Stream<Substation> getSubstationStream() {
        return this.getNetwork().getSubstationStream().filter(this::contains);
    }

    public int getSubstationCount() {
        return (int)this.getSubstationStream().count();
    }

    public Iterable<Substation> getSubstations(Country country, String tsoId, String ... geographicalTags) {
        return StreamSupport.stream(this.getNetwork().getSubstations(country, tsoId, geographicalTags).spliterator(), false).filter(this::contains).toList();
    }

    public Iterable<Substation> getSubstations(String country, String tsoId, String ... geographicalTags) {
        return StreamSupport.stream(this.getNetwork().getSubstations(country, tsoId, geographicalTags).spliterator(), false).filter(this::contains).toList();
    }

    public Substation getSubstation(String id) {
        SubstationImpl s = this.getNetwork().getSubstation(id);
        return this.contains(s) ? s : null;
    }

    public VoltageLevelAdder newVoltageLevel() {
        return new VoltageLevelAdderImpl((Ref<NetworkImpl>)this.rootNetworkRef, (Ref<SubnetworkImpl>)this.ref);
    }

    public Iterable<VoltageLevel> getVoltageLevels() {
        return this.getVoltageLevelStream().toList();
    }

    public Stream<VoltageLevel> getVoltageLevelStream() {
        return this.getNetwork().getVoltageLevelStream().filter(this::contains);
    }

    public int getVoltageLevelCount() {
        return (int)this.getVoltageLevelStream().count();
    }

    public VoltageLevel getVoltageLevel(String id) {
        VoltageLevelExt vl = this.getNetwork().getVoltageLevel(id);
        return this.contains((Identifiable<?>)vl) ? vl : null;
    }

    public LineAdder newLine() {
        return this.getNetwork().newLine(this.id);
    }

    public Iterable<Line> getLines() {
        return this.getLineStream().toList();
    }

    public Branch<?> getBranch(String branchId) {
        Branch b = this.getNetwork().getBranch(branchId);
        return this.contains((Identifiable<?>)b) ? b : null;
    }

    public Iterable<Branch> getBranches() {
        return this.getBranchStream().toList();
    }

    public Stream<Branch> getBranchStream() {
        return this.getNetwork().getBranchStream().filter(this::contains);
    }

    public int getBranchCount() {
        return (int)this.getBranchStream().count();
    }

    public Stream<Line> getLineStream() {
        return this.getNetwork().getLineStream().filter(this::contains);
    }

    public int getLineCount() {
        return (int)this.getLineStream().count();
    }

    public Line getLine(String id) {
        Line l = this.getNetwork().getLine(id);
        return this.contains((Identifiable<?>)l) ? l : null;
    }

    public VoltageAngleLimitAdder newVoltageAngleLimit() {
        return this.getNetwork().newVoltageAngleLimit(this.id);
    }

    public Iterable<VoltageAngleLimit> getVoltageAngleLimits() {
        return this.getVoltageAngleLimitsStream().toList();
    }

    public Stream<VoltageAngleLimit> getVoltageAngleLimitsStream() {
        return this.getNetwork().getVoltageAngleLimitsStream().filter(val -> this.contains((Identifiable<?>)val.getTerminalFrom().getVoltageLevel()) && this.contains((Identifiable<?>)val.getTerminalTo().getVoltageLevel()));
    }

    public VoltageAngleLimit getVoltageAngleLimit(String id) {
        VoltageAngleLimitImpl val = (VoltageAngleLimitImpl)this.getNetwork().getVoltageAngleLimit(id);
        boolean valInSubnetwork = val != null && this.contains((Identifiable<?>)val.getTerminalFrom().getVoltageLevel()) && this.contains((Identifiable<?>)val.getTerminalTo().getVoltageLevel());
        return valInSubnetwork ? val : null;
    }

    public TieLineAdder newTieLine() {
        return this.getNetwork().newTieLine(this.id);
    }

    public Iterable<TieLine> getTieLines() {
        return this.getTieLineStream().toList();
    }

    public Stream<TieLine> getTieLineStream() {
        return this.getNetwork().getTieLineStream().filter(this::contains);
    }

    public int getTieLineCount() {
        return (int)this.getTieLineStream().count();
    }

    public TieLine getTieLine(String id) {
        TieLine t = this.getNetwork().getTieLine(id);
        return this.contains((Identifiable<?>)t) ? t : null;
    }

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers() {
        return this.getTwoWindingsTransformerStream().toList();
    }

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream() {
        return this.getNetwork().getTwoWindingsTransformerStream().filter(this::contains);
    }

    public int getTwoWindingsTransformerCount() {
        return (int)this.getTwoWindingsTransformerStream().count();
    }

    public TwoWindingsTransformer getTwoWindingsTransformer(String id) {
        TwoWindingsTransformer twt = this.getNetwork().getTwoWindingsTransformer(id);
        return this.contains((Identifiable<?>)twt) ? twt : null;
    }

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers() {
        return this.getThreeWindingsTransformerStream().toList();
    }

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream() {
        return this.getNetwork().getThreeWindingsTransformerStream().filter(this::contains);
    }

    public int getThreeWindingsTransformerCount() {
        return (int)this.getThreeWindingsTransformerStream().count();
    }

    public ThreeWindingsTransformer getThreeWindingsTransformer(String id) {
        ThreeWindingsTransformer twt = this.getNetwork().getThreeWindingsTransformer(id);
        return this.contains((Identifiable<?>)twt) ? twt : null;
    }

    public Iterable<OverloadManagementSystem> getOverloadManagementSystems() {
        return this.getOverloadManagementSystemStream().toList();
    }

    public Stream<OverloadManagementSystem> getOverloadManagementSystemStream() {
        return this.getNetwork().getOverloadManagementSystemStream().filter(this::contains);
    }

    public int getOverloadManagementSystemCount() {
        return (int)this.getOverloadManagementSystemStream().count();
    }

    public OverloadManagementSystem getOverloadManagementSystem(String id) {
        OverloadManagementSystem oms = this.getNetwork().getOverloadManagementSystem(id);
        return this.contains((Identifiable<?>)oms) ? oms : null;
    }

    public Iterable<Generator> getGenerators() {
        return this.getGeneratorStream().toList();
    }

    public Stream<Generator> getGeneratorStream() {
        return this.getNetwork().getGeneratorStream().filter(this::contains);
    }

    public int getGeneratorCount() {
        return (int)this.getGeneratorStream().count();
    }

    public Generator getGenerator(String id) {
        GeneratorImpl g = this.getNetwork().getGenerator(id);
        return this.contains(g) ? g : null;
    }

    public Iterable<Battery> getBatteries() {
        return this.getBatteryStream().toList();
    }

    public Stream<Battery> getBatteryStream() {
        return this.getNetwork().getBatteryStream().filter(this::contains);
    }

    public int getBatteryCount() {
        return (int)this.getBatteryStream().count();
    }

    public Battery getBattery(String id) {
        BatteryImpl b = this.getNetwork().getBattery(id);
        return this.contains(b) ? b : null;
    }

    public Iterable<Load> getLoads() {
        return this.getLoadStream().toList();
    }

    public Stream<Load> getLoadStream() {
        return this.getNetwork().getLoadStream().filter(this::contains);
    }

    public int getLoadCount() {
        return (int)this.getLoadStream().count();
    }

    public Load getLoad(String id) {
        LoadImpl l = this.getNetwork().getLoad(id);
        return this.contains(l) ? l : null;
    }

    public Iterable<ShuntCompensator> getShuntCompensators() {
        return this.getShuntCompensatorStream().toList();
    }

    public Stream<ShuntCompensator> getShuntCompensatorStream() {
        return this.getNetwork().getShuntCompensatorStream().filter(this::contains);
    }

    public int getShuntCompensatorCount() {
        return (int)this.getShuntCompensatorStream().count();
    }

    public ShuntCompensator getShuntCompensator(String id) {
        ShuntCompensatorImpl s = this.getNetwork().getShuntCompensator(id);
        return this.contains(s) ? s : null;
    }

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter danglingLineFilter) {
        return this.getDanglingLineStream(danglingLineFilter).toList();
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter danglingLineFilter) {
        return this.getNetwork().getDanglingLineStream().filter(this::contains).filter(danglingLineFilter.getPredicate());
    }

    public Iterable<DanglingLine> getDanglingLines() {
        return this.getDanglingLines(DanglingLineFilter.ALL);
    }

    public Stream<DanglingLine> getDanglingLineStream() {
        return this.getDanglingLineStream(DanglingLineFilter.ALL);
    }

    public int getDanglingLineCount() {
        return (int)this.getDanglingLineStream().count();
    }

    public DanglingLine getDanglingLine(String id) {
        DanglingLineImpl dl = this.getNetwork().getDanglingLine(id);
        return this.contains(dl) ? dl : null;
    }

    public Iterable<StaticVarCompensator> getStaticVarCompensators() {
        return this.getStaticVarCompensatorStream().toList();
    }

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream() {
        return this.getNetwork().getStaticVarCompensatorStream().filter(this::contains);
    }

    public int getStaticVarCompensatorCount() {
        return (int)this.getStaticVarCompensatorStream().count();
    }

    public StaticVarCompensator getStaticVarCompensator(String id) {
        StaticVarCompensatorImpl s = this.getNetwork().getStaticVarCompensator(id);
        return this.contains(s) ? s : null;
    }

    public Switch getSwitch(String id) {
        Switch s = this.getNetwork().getSwitch(id);
        return this.contains((Identifiable<?>)s) ? s : null;
    }

    public Iterable<Switch> getSwitches() {
        return this.getSwitchStream().toList();
    }

    public Stream<Switch> getSwitchStream() {
        return this.getNetwork().getSwitchStream().filter(this::contains);
    }

    public int getSwitchCount() {
        return (int)this.getSwitchStream().count();
    }

    public BusbarSection getBusbarSection(String id) {
        BusbarSection b = this.getNetwork().getBusbarSection(id);
        return this.contains((Identifiable<?>)b) ? b : null;
    }

    public Iterable<BusbarSection> getBusbarSections() {
        return this.getBusbarSectionStream().toList();
    }

    public Stream<BusbarSection> getBusbarSectionStream() {
        return this.getNetwork().getBusbarSectionStream().filter(this::contains);
    }

    public int getBusbarSectionCount() {
        return (int)this.getBusbarSectionStream().count();
    }

    public Iterable<HvdcConverterStation<?>> getHvdcConverterStations() {
        return this.getHvdcConverterStationStream().toList();
    }

    public Stream<HvdcConverterStation<?>> getHvdcConverterStationStream() {
        return this.getNetwork().getHvdcConverterStationStream().filter(this::contains);
    }

    public int getHvdcConverterStationCount() {
        return (int)this.getHvdcConverterStationStream().count();
    }

    public HvdcConverterStation<?> getHvdcConverterStation(String id) {
        HvdcConverterStation s = this.getNetwork().getHvdcConverterStation(id);
        return this.contains((Identifiable<?>)s) ? s : null;
    }

    public Iterable<LccConverterStation> getLccConverterStations() {
        return this.getLccConverterStationStream().toList();
    }

    public Stream<LccConverterStation> getLccConverterStationStream() {
        return this.getNetwork().getLccConverterStationStream().filter(this::contains);
    }

    public int getLccConverterStationCount() {
        return (int)this.getLccConverterStationStream().count();
    }

    public LccConverterStation getLccConverterStation(String id) {
        LccConverterStationImpl s = this.getNetwork().getLccConverterStation(id);
        return this.contains(s) ? s : null;
    }

    public Iterable<VscConverterStation> getVscConverterStations() {
        return this.getVscConverterStationStream().toList();
    }

    public Stream<VscConverterStation> getVscConverterStationStream() {
        return this.getNetwork().getVscConverterStationStream().filter(this::contains);
    }

    public int getVscConverterStationCount() {
        return (int)this.getVscConverterStationStream().count();
    }

    public VscConverterStation getVscConverterStation(String id) {
        VscConverterStationImpl s = this.getNetwork().getVscConverterStation(id);
        return this.contains(s) ? s : null;
    }

    public Iterable<HvdcLine> getHvdcLines() {
        return this.getHvdcLineStream().toList();
    }

    public Stream<HvdcLine> getHvdcLineStream() {
        return this.getNetwork().getHvdcLineStream().filter(this::contains);
    }

    public int getHvdcLineCount() {
        return (int)this.getHvdcLineStream().count();
    }

    public HvdcLine getHvdcLine(String id) {
        HvdcLine l = this.getNetwork().getHvdcLine(id);
        return this.contains((Identifiable<?>)l) ? l : null;
    }

    public HvdcLine getHvdcLine(HvdcConverterStation converterStation) {
        if (converterStation.getParentNetwork() == this) {
            return this.getHvdcLineStream().filter(l -> l.getConverterStation1() == converterStation || l.getConverterStation2() == converterStation).findFirst().orElse(null);
        }
        return null;
    }

    public HvdcLineAdder newHvdcLine() {
        return this.getNetwork().newHvdcLine(this.id);
    }

    public Ground getGround(String id) {
        Ground s = this.getNetwork().getGround(id);
        return this.contains((Identifiable<?>)s) ? s : null;
    }

    public Iterable<Ground> getGrounds() {
        return this.getGroundStream().toList();
    }

    public Stream<Ground> getGroundStream() {
        return this.getNetwork().getGroundStream().filter(this::contains);
    }

    public int getGroundCount() {
        return (int)this.getGroundStream().count();
    }

    public Identifiable<?> getIdentifiable(String id) {
        Identifiable<?> i = this.getNetwork().getIdentifiable(id);
        return this.contains(i) ? i : null;
    }

    public Collection<Identifiable<?>> getIdentifiables() {
        return this.getNetwork().getIdentifiables().stream().filter(this::contains).toList();
    }

    public <C extends Connectable> Iterable<C> getConnectables(Class<C> clazz) {
        return this.getConnectableStream(clazz).toList();
    }

    public <C extends Connectable> Stream<C> getConnectableStream(Class<C> clazz) {
        return this.getNetwork().getConnectableStream(clazz).filter(this::contains);
    }

    public <C extends Connectable> int getConnectableCount(Class<C> clazz) {
        return (int)this.getConnectableStream(clazz).count();
    }

    public Iterable<Connectable> getConnectables() {
        return this.getConnectableStream().toList();
    }

    public Stream<Connectable> getConnectableStream() {
        return this.getNetwork().getConnectableStream().filter(this::contains);
    }

    public Connectable<?> getConnectable(String id) {
        Connectable<?> c = this.getNetwork().getConnectable(id);
        return this.contains((Identifiable<?>)c) ? c : null;
    }

    public int getConnectableCount() {
        return (int)this.getConnectableStream().count();
    }

    public Network.BusBreakerView getBusBreakerView() {
        return this.busBreakerView;
    }

    public Network.BusView getBusView() {
        return this.busView;
    }

    public Network createSubnetwork(String subnetworkId, String name, String sourceFormat) {
        throw new UnsupportedOperationException("Inner subnetworks are not yet supported");
    }

    public Network detach() {
        Set<Identifiable<?>> boundaryElements = this.getBoundaryElements();
        this.checkDetachable(boundaryElements, true);
        long start = System.currentTimeMillis();
        boundaryElements.stream().filter(DanglingLine.class::isInstance).map(DanglingLine.class::cast).map(DanglingLine::getTieLine).filter(Optional::isPresent).forEach(t -> ((TieLine)t.get()).remove(true));
        NetworkImpl detachedNetwork = new NetworkImpl(this.getId(), this.getNameOrId(), this.getSourceFormat());
        SubnetworkImpl.transferExtensions(this, detachedNetwork);
        SubnetworkImpl.transferProperties(this, detachedNetwork);
        Collection<Identifiable<?>> identifiables = this.getIdentifiables();
        Iterable<VoltageAngleLimit> vals = this.getVoltageAngleLimits();
        this.ref.setRef((Ref)new RefObj(null));
        NetworkImpl previousRootNetwork = (NetworkImpl)this.rootNetworkRef.get();
        previousRootNetwork.removeFromSubnetworks(this.getId());
        this.rootNetworkRef.setRef(detachedNetwork.getRef());
        for (Identifiable<?> i : identifiables) {
            previousRootNetwork.getIndex().remove(i);
            if (i == this) continue;
            detachedNetwork.getIndex().checkAndAdd(i);
        }
        for (VoltageAngleLimit val : vals) {
            previousRootNetwork.getVoltageAngleLimitsIndex().remove(val.getId());
            detachedNetwork.getVoltageAngleLimitsIndex().put(val.getId(), val);
        }
        detachedNetwork.getAreaStream().forEach(a -> {
            AreaImpl area = (AreaImpl)a;
            area.moveListener(previousRootNetwork, detachedNetwork);
        });
        LOGGER.info("Detaching of {} done in {} ms", (Object)this.id, (Object)(System.currentTimeMillis() - start));
        return detachedNetwork;
    }

    public boolean isDetachable() {
        return this.checkDetachable(this.getBoundaryElements(), false);
    }

    private boolean checkDetachable(Set<Identifiable<?>> boundaryElements, boolean throwsException) {
        if (this.getNetwork().getVariantManager().getVariantArraySize() != 1) {
            if (throwsException) {
                throw new PowsyblException("Detaching from multi-variants network is not supported");
            }
            return false;
        }
        if (boundaryElements.stream().anyMatch(Predicate.not(SubnetworkImpl::isSplittable))) {
            if (throwsException) {
                throw new PowsyblException("Un-splittable boundary elements prevent the subnetwork to be detached: " + boundaryElements.stream().filter(Predicate.not(SubnetworkImpl::isSplittable)).map(Identifiable::getId).collect(Collectors.joining(", ")));
            }
            return false;
        }
        if (this.getNetwork().getVoltageAngleLimitsStream().anyMatch(this::isBoundary)) {
            if (throwsException) {
                throw new PowsyblException("VoltageAngleLimits prevent the subnetwork to be detached: " + this.getNetwork().getVoltageAngleLimitsStream().filter(this::isBoundary).map(VoltageAngleLimit::getId).collect(Collectors.joining(", ")));
            }
            return false;
        }
        return true;
    }

    private static boolean isSplittable(Identifiable<?> identifiable) {
        return identifiable.getType() == IdentifiableType.DANGLING_LINE;
    }

    public Set<Identifiable<?>> getBoundaryElements() {
        Stream<Line> lines = this.getNetwork().getLineStream().filter(i -> i.getParentNetwork() == this.getNetwork());
        Stream<DanglingLine> danglingLineStream = this.getDanglingLineStream();
        Stream<HvdcLine> hvdcLineStream = this.getNetwork().getHvdcLineStream().filter(i -> i.getParentNetwork() == this.getNetwork());
        return Stream.of(lines, danglingLineStream, hvdcLineStream).flatMap(Function.identity()).map(o -> (Identifiable)o).filter(this::isBoundaryElement).collect(Collectors.toSet());
    }

    public boolean isBoundaryElement(Identifiable<?> identifiable) {
        return switch (identifiable.getType()) {
            case IdentifiableType.LINE, IdentifiableType.TIE_LINE -> this.isBoundary((Branch)identifiable);
            case IdentifiableType.HVDC_LINE -> this.isBoundary((HvdcLine)identifiable);
            case IdentifiableType.DANGLING_LINE -> this.isBoundary((DanglingLine)identifiable);
            default -> false;
        };
    }

    public void flatten() {
        throw new UnsupportedOperationException("Subnetworks cannot be flattened.");
    }

    private boolean isBoundary(Branch<?> branch) {
        return this.isBoundary(branch.getTerminal1(), branch.getTerminal2());
    }

    private boolean isBoundary(HvdcLine hvdcLine) {
        return this.isBoundary(hvdcLine.getConverterStation1().getTerminal(), hvdcLine.getConverterStation2().getTerminal());
    }

    private boolean isBoundary(DanglingLine danglingLine) {
        return danglingLine.getTieLine().map(this::isBoundary).orElse(true);
    }

    private boolean isBoundary(VoltageAngleLimit val) {
        return this.isBoundary(val.getTerminalFrom(), val.getTerminalTo());
    }

    private boolean isBoundary(Terminal terminal1, Terminal terminal2) {
        boolean containsVoltageLevel1 = this.contains((Identifiable<?>)terminal1.getVoltageLevel());
        boolean containsVoltageLevel2 = this.contains((Identifiable<?>)terminal2.getVoltageLevel());
        return containsVoltageLevel1 && !containsVoltageLevel2 || !containsVoltageLevel1 && containsVoltageLevel2;
    }

    public void addListener(NetworkListener listener) {
        throw new PowsyblException("Listeners are not managed at subnetwork level. Add this listener to the parent network '" + this.getNetwork().getId() + "'");
    }

    public void removeListener(NetworkListener listener) {
        throw new PowsyblException("Listeners are not managed at subnetwork level. Remove this listener to the parent network '" + this.getNetwork().getId() + "'");
    }

    public ValidationLevel runValidationChecks() {
        return this.getNetwork().runValidationChecks();
    }

    public ValidationLevel runValidationChecks(boolean throwsException) {
        return this.getNetwork().runValidationChecks(throwsException);
    }

    public ValidationLevel runValidationChecks(boolean throwsException, ReportNode reportNode) {
        return this.getNetwork().runValidationChecks(throwsException, reportNode);
    }

    public ValidationLevel getValidationLevel() {
        return this.getNetwork().getValidationLevel();
    }

    public Network setMinimumAcceptableValidationLevel(ValidationLevel validationLevel) {
        return this.getNetwork().setMinimumAcceptableValidationLevel(validationLevel);
    }

    public Stream<Identifiable<?>> getIdentifiableStream(IdentifiableType identifiableType) {
        return this.getNetwork().getIdentifiableStream(identifiableType).filter(this::contains);
    }

    class BusBreakerViewImpl
    extends AbstractNetwork.AbstractBusBreakerViewImpl {
        BusBreakerViewImpl() {
            super(SubnetworkImpl.this);
        }

        public Bus getBus(String id) {
            Bus b = SubnetworkImpl.this.getNetwork().getBusBreakerView().getBus(id);
            return SubnetworkImpl.this.contains((Identifiable<?>)b) ? b : null;
        }
    }

    class BusViewImpl
    extends AbstractNetwork.AbstractBusViewImpl {
        BusViewImpl() {
            super(SubnetworkImpl.this);
        }

        public Bus getBus(String id) {
            Bus b = SubnetworkImpl.this.getNetwork().getBusView().getBus(id);
            return SubnetworkImpl.this.contains((Identifiable<?>)b) ? b : null;
        }

        public Collection<Component> getConnectedComponents() {
            return SubnetworkImpl.this.getNetwork().getBusView().getConnectedComponents().stream().filter(c -> c.getBusStream().anyMatch(SubnetworkImpl.this::contains)).map(c -> new Subcomponent((Component)c, SubnetworkImpl.this)).toList();
        }

        public Collection<Component> getSynchronousComponents() {
            return SubnetworkImpl.this.getNetwork().getBusView().getSynchronousComponents().stream().filter(c -> c.getBusStream().anyMatch(SubnetworkImpl.this::contains)).map(c -> new Subcomponent((Component)c, SubnetworkImpl.this)).toList();
        }
    }
}

