/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.impl.NetworkImpl;
import java.util.OptionalDouble;

class VoltageAngleLimitImpl
implements VoltageAngleLimit {
    private final Ref<NetworkImpl> networkRef;
    private final String id;
    private final Terminal fromTerminal;
    private final Terminal toTerminal;
    private final double lowLimit;
    private final double highLimit;

    VoltageAngleLimitImpl(String id, Terminal fromTerminal, Terminal toTerminal, double lowLimit, double highLimit, Ref<NetworkImpl> networkRef) {
        this.id = id;
        this.fromTerminal = fromTerminal;
        this.toTerminal = toTerminal;
        this.lowLimit = lowLimit;
        this.highLimit = highLimit;
        this.networkRef = networkRef;
    }

    public String getId() {
        return this.id;
    }

    public Terminal getTerminalFrom() {
        return this.fromTerminal;
    }

    public Terminal getTerminalTo() {
        return this.toTerminal;
    }

    public OptionalDouble getLowLimit() {
        return Double.isNaN(this.lowLimit) ? OptionalDouble.empty() : OptionalDouble.of(this.lowLimit);
    }

    public OptionalDouble getHighLimit() {
        return Double.isNaN(this.highLimit) ? OptionalDouble.empty() : OptionalDouble.of(this.highLimit);
    }

    public void remove() {
        ((NetworkImpl)this.networkRef.get()).getVoltageAngleLimitsIndex().remove(this.id);
    }
}

