/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.impl.AbstractHvdcConverterStation;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsAdderImpl;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ReactiveCapabilityCurveAdderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsHolderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsOwner;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TerminalExt;
import gnu.trove.list.array.TDoubleArrayList;

class VscConverterStationImpl
extends AbstractHvdcConverterStation<VscConverterStation>
implements VscConverterStation,
ReactiveLimitsOwner {
    static final String TYPE_DESCRIPTION = "vscConverterStation";
    private final ReactiveLimitsHolderImpl reactiveLimits;
    private final TDoubleArrayList reactivePowerSetpoint;
    private final TDoubleArrayList voltageSetpoint;
    private final RegulatingPoint regulatingPoint;

    VscConverterStationImpl(String id, String name, boolean fictitious, float lossFactor, Ref<NetworkImpl> ref, boolean voltageRegulatorOn, double reactivePowerSetpoint, double voltageSetpoint, TerminalExt regulatingTerminal) {
        super(ref, id, name, fictitious, lossFactor);
        int variantArraySize = ((NetworkImpl)ref.get()).getVariantManager().getVariantArraySize();
        this.reactivePowerSetpoint = new TDoubleArrayList(variantArraySize);
        this.voltageSetpoint = new TDoubleArrayList(variantArraySize);
        this.reactivePowerSetpoint.fill(0, variantArraySize, reactivePowerSetpoint);
        this.voltageSetpoint.fill(0, variantArraySize, voltageSetpoint);
        this.reactiveLimits = new ReactiveLimitsHolderImpl(this, (ReactiveLimits)new MinMaxReactiveLimitsImpl(-1.7976931348623157E308, Double.MAX_VALUE));
        this.regulatingPoint = new RegulatingPoint(id, this::getTerminal, variantArraySize, voltageRegulatorOn, voltageRegulatorOn);
        this.regulatingPoint.setRegulatingTerminal(regulatingTerminal);
    }

    public HvdcConverterStation.HvdcType getHvdcType() {
        return HvdcConverterStation.HvdcType.VSC;
    }

    @Override
    protected String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public boolean isVoltageRegulatorOn() {
        return this.regulatingPoint.isRegulating(this.getNetwork().getVariantIndex());
    }

    public VscConverterStationImpl setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)voltageRegulatorOn, (double)this.voltageSetpoint.get(variantIndex), (double)this.reactivePowerSetpoint.get(variantIndex), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        boolean oldValue = this.regulatingPoint.isRegulating(variantIndex);
        this.regulatingPoint.setRegulating(variantIndex, voltageRegulatorOn);
        this.regulatingPoint.setUseVoltageRegulation(voltageRegulatorOn);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("voltageRegulatorOn", variantId, (Object)oldValue, (Object)voltageRegulatorOn);
        return this;
    }

    public double getVoltageSetpoint() {
        return this.voltageSetpoint.get(this.getNetwork().getVariantIndex());
    }

    public VscConverterStationImpl setVoltageSetpoint(double voltageSetpoint) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.regulatingPoint.isRegulating(variantIndex), (double)voltageSetpoint, (double)this.reactivePowerSetpoint.get(variantIndex), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        double oldValue = this.voltageSetpoint.set(variantIndex, voltageSetpoint);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("voltageSetpoint", variantId, (Object)oldValue, (Object)voltageSetpoint);
        return this;
    }

    public double getReactivePowerSetpoint() {
        return this.reactivePowerSetpoint.get(this.getNetwork().getVariantIndex());
    }

    public VscConverterStationImpl setReactivePowerSetpoint(double reactivePowerSetpoint) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.regulatingPoint.isRegulating(variantIndex), (double)this.voltageSetpoint.get(variantIndex), (double)reactivePowerSetpoint, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        double oldValue = this.reactivePowerSetpoint.set(variantIndex, reactivePowerSetpoint);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("reactivePowerSetpoint", variantId, (Object)oldValue, (Object)reactivePowerSetpoint);
        return this;
    }

    public ReactiveCapabilityCurveAdderImpl newReactiveCapabilityCurve() {
        return new ReactiveCapabilityCurveAdderImpl<VscConverterStationImpl>(this);
    }

    public MinMaxReactiveLimitsAdderImpl newMinMaxReactiveLimits() {
        return new MinMaxReactiveLimitsAdderImpl<VscConverterStationImpl>(this);
    }

    @Override
    public void setReactiveLimits(ReactiveLimits reactiveLimits) {
        this.reactiveLimits.setReactiveLimits(reactiveLimits);
    }

    public ReactiveLimits getReactiveLimits() {
        return this.reactiveLimits.getReactiveLimits();
    }

    public <L extends ReactiveLimits> L getReactiveLimits(Class<L> type) {
        return this.reactiveLimits.getReactiveLimits(type);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.reactivePowerSetpoint.ensureCapacity(this.reactivePowerSetpoint.size() + number);
        this.reactivePowerSetpoint.fill(initVariantArraySize, initVariantArraySize + number, this.reactivePowerSetpoint.get(sourceIndex));
        this.voltageSetpoint.ensureCapacity(this.voltageSetpoint.size() + number);
        this.voltageSetpoint.fill(initVariantArraySize, initVariantArraySize + number, this.voltageSetpoint.get(sourceIndex));
        this.regulatingPoint.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.reactivePowerSetpoint.remove(this.reactivePowerSetpoint.size() - number, number);
        this.voltageSetpoint.remove(this.voltageSetpoint.size() - number, number);
        this.regulatingPoint.reduceVariantArraySize(number);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.reactivePowerSetpoint.set(index, this.reactivePowerSetpoint.get(sourceIndex));
            this.voltageSetpoint.set(index, this.voltageSetpoint.get(sourceIndex));
        }
        this.regulatingPoint.allocateVariantArrayElement(indexes, sourceIndex);
    }

    public TerminalExt getRegulatingTerminal() {
        return this.regulatingPoint.getRegulatingTerminal();
    }

    public VscConverterStationImpl setRegulatingTerminal(Terminal regulatingTerminal) {
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)regulatingTerminal, (Network)this.getNetwork());
        TerminalExt oldValue = this.regulatingPoint.getRegulatingTerminal();
        this.regulatingPoint.setRegulatingTerminal((TerminalExt)regulatingTerminal);
        this.notifyUpdate("regulatingTerminal", (Object)oldValue, (Object)regulatingTerminal);
        return this;
    }

    @Override
    public void remove() {
        this.regulatingPoint.remove();
        super.remove();
    }
}

