/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.iidm.network.extensions.ControlUnit;
import com.powsybl.iidm.network.extensions.ControlZone;
import com.powsybl.iidm.network.extensions.PilotPoint;
import com.powsybl.iidm.network.impl.extensions.SecondaryVoltageControlImpl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class ControlZoneImpl
implements ControlZone {
    private SecondaryVoltageControlImpl secondaryVoltageControl;
    private final String name;
    private final PilotPoint pilotPoint;
    private final List<ControlUnit> controlUnits;

    ControlZoneImpl(String name, PilotPoint pilotPoint, List<ControlUnit> controlUnits) {
        this.name = Objects.requireNonNull(name);
        this.pilotPoint = Objects.requireNonNull(pilotPoint);
        this.controlUnits = Objects.requireNonNull(controlUnits);
    }

    void setSecondaryVoltageControl(SecondaryVoltageControlImpl secondaryVoltageControl) {
        this.secondaryVoltageControl = Objects.requireNonNull(secondaryVoltageControl);
    }

    public SecondaryVoltageControlImpl getSecondaryVoltageControl() {
        return this.secondaryVoltageControl;
    }

    public String getName() {
        return this.name;
    }

    public PilotPoint getPilotPoint() {
        return this.pilotPoint;
    }

    public List<ControlUnit> getControlUnits() {
        return Collections.unmodifiableList(this.controlUnits);
    }

    public Optional<ControlUnit> getControlUnit(String id) {
        Objects.requireNonNull(id);
        return this.controlUnits.stream().filter(u -> u.getId().equals(id)).findFirst();
    }
}

