/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.extensions.DiscreteMeasurement;
import com.powsybl.iidm.network.extensions.DiscreteMeasurementAdder;
import com.powsybl.iidm.network.extensions.DiscreteMeasurements;
import com.powsybl.iidm.network.impl.extensions.DiscreteMeasurementAdderImpl;
import com.powsybl.iidm.network.impl.extensions.DiscreteMeasurementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class DiscreteMeasurementsImpl<I extends Identifiable<I>>
extends AbstractExtension<I>
implements DiscreteMeasurements<I> {
    private final List<DiscreteMeasurementImpl> discreteMeasurements = new ArrayList<DiscreteMeasurementImpl>();

    DiscreteMeasurementsImpl() {
    }

    DiscreteMeasurementsImpl<I> add(DiscreteMeasurementImpl discreteMeasurement) {
        this.discreteMeasurements.add(discreteMeasurement);
        return this;
    }

    void remove(DiscreteMeasurementImpl discreteMeasurement) {
        this.discreteMeasurements.remove(discreteMeasurement);
    }

    public Collection<DiscreteMeasurement> getDiscreteMeasurements() {
        return Collections.unmodifiableList(this.discreteMeasurements);
    }

    public Collection<DiscreteMeasurement> getDiscreteMeasurements(DiscreteMeasurement.Type type) {
        return this.discreteMeasurements.stream().filter(dm -> dm.getType() == type).collect(Collectors.toList());
    }

    public DiscreteMeasurement getDiscreteMeasurement(String id) {
        return this.discreteMeasurements.stream().filter(d -> d.getId() != null && d.getId().equals(id)).findFirst().orElse(null);
    }

    public DiscreteMeasurementAdder newDiscreteMeasurement() {
        return new DiscreteMeasurementAdderImpl(this);
    }
}

