/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.google.common.collect.ImmutableSet;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DefaultNetworkListener;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkListener;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.ReferenceTerminals;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

class ReferenceTerminalsImpl
extends AbstractMultiVariantIdentifiableExtension<Network>
implements ReferenceTerminals {
    private final NetworkListener referenceTerminalsListener;
    private final ArrayList<Set<Terminal>> terminalsPerVariant = new ArrayList<LinkedHashSet<Set<Terminal>>>(Collections.nCopies(this.getVariantManagerHolder().getVariantManager().getVariantArraySize(), new LinkedHashSet()));

    public ReferenceTerminalsImpl(Network network, Set<Terminal> terminals) {
        super(network);
        this.setReferenceTerminals(terminals);
        this.referenceTerminalsListener = new ReferenceTerminalsListener();
    }

    public void setExtendable(Network extendable) {
        super.setExtendable((Object)extendable);
        if (extendable != null) {
            extendable.getNetwork().addListener(this.referenceTerminalsListener);
        }
    }

    protected void cleanup() {
        ((Network)this.getExtendable()).getNetwork().removeListener(this.referenceTerminalsListener);
    }

    public Set<Terminal> getReferenceTerminals() {
        return ImmutableSet.copyOf((Collection)this.terminalsPerVariant.get(this.getVariantIndex()));
    }

    public void setReferenceTerminals(Set<Terminal> terminals) {
        Objects.requireNonNull(terminals);
        terminals.forEach(t -> ReferenceTerminalsImpl.checkTerminalInNetwork(t, (Network)this.getExtendable()));
        this.terminalsPerVariant.set(this.getVariantIndex(), new LinkedHashSet<Terminal>(terminals));
    }

    public ReferenceTerminals reset() {
        this.terminalsPerVariant.set(this.getVariantIndex(), new LinkedHashSet());
        return this;
    }

    public ReferenceTerminals addReferenceTerminal(Terminal terminal) {
        Objects.requireNonNull(terminal);
        ReferenceTerminalsImpl.checkTerminalInNetwork(terminal, (Network)this.getExtendable());
        this.terminalsPerVariant.get(this.getVariantIndex()).add(terminal);
        return this;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.terminalsPerVariant.ensureCapacity(this.terminalsPerVariant.size() + number);
        Set<Terminal> sourceTerminals = this.terminalsPerVariant.get(sourceIndex);
        for (int i = 0; i < number; ++i) {
            this.terminalsPerVariant.add(new LinkedHashSet<Terminal>(sourceTerminals));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int i = 0; i < number; ++i) {
            this.terminalsPerVariant.remove(this.terminalsPerVariant.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.terminalsPerVariant.set(index, new LinkedHashSet());
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        Set<Terminal> sourceTerminals = this.terminalsPerVariant.get(sourceIndex);
        for (int index : indexes) {
            this.terminalsPerVariant.set(index, new LinkedHashSet<Terminal>(sourceTerminals));
        }
    }

    private static void checkTerminalInNetwork(Terminal terminal, Network network) {
        boolean extendableIsRootNetwork = network.getNetwork().equals(network);
        if (extendableIsRootNetwork) {
            if (!terminal.getVoltageLevel().getNetwork().equals(network)) {
                throw new PowsyblException("Terminal given is not in the right Network (" + terminal.getVoltageLevel().getNetwork().getId() + " instead of " + network.getId() + ")");
            }
        } else if (!terminal.getVoltageLevel().getParentNetwork().equals(network)) {
            throw new PowsyblException("Terminal given is not in the right Network (" + terminal.getVoltageLevel().getParentNetwork().getId() + " instead of " + network.getId() + ")");
        }
    }

    private final class ReferenceTerminalsListener
    extends DefaultNetworkListener {
        private ReferenceTerminalsListener() {
        }

        public void beforeRemoval(Identifiable<?> identifiable) {
            if (identifiable instanceof Connectable) {
                Connectable connectable = (Connectable)identifiable;
                ReferenceTerminalsImpl.this.terminalsPerVariant.forEach((Consumer<Set<Terminal>>)((Consumer<Set>)referenceTerminals -> connectable.getTerminals().forEach(referenceTerminals::remove)));
            }
        }
    }
}

