/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaBoundaryAdder;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.impl.AreaBoundaryImpl;
import com.powsybl.iidm.network.impl.AreaImpl;
import java.util.Objects;

public class AreaBoundaryAdderImpl
implements AreaBoundaryAdder {
    AreaImpl area;
    Boundary boundary;
    Terminal terminal;
    Boolean ac;

    AreaBoundaryAdderImpl(AreaImpl area) {
        this.area = Objects.requireNonNull(area);
    }

    public AreaBoundaryAdder setBoundary(Boundary boundary) {
        this.boundary = boundary;
        this.terminal = null;
        return this;
    }

    public AreaBoundaryAdder setTerminal(Terminal terminal) {
        this.terminal = terminal;
        this.boundary = null;
        return this;
    }

    public AreaBoundaryAdder setAc(boolean ac) {
        this.ac = ac;
        return this;
    }

    public Area add() {
        if (this.ac == null) {
            throw new PowsyblException("AreaBoundary AC flag is not set.");
        }
        if (this.boundary != null) {
            this.area.removeAreaBoundary(this.boundary);
            this.area.addAreaBoundary(new AreaBoundaryImpl((Area)this.area, this.boundary, (boolean)this.ac));
        } else if (this.terminal != null) {
            this.area.removeAreaBoundary(this.terminal);
            this.area.addAreaBoundary(new AreaBoundaryImpl((Area)this.area, this.terminal, (boolean)this.ac));
        } else {
            throw new PowsyblException("No AreaBoundary element (terminal or boundary) is set.");
        }
        return this.area;
    }
}

